/*
 * checknx
 * 05.07.24 : Makoto NARA (Mc.N)
 */

/*
 * Copyright (c) 2005 Makoto NARA (Mc.N) All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY Makoto NARA (Mc.N) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#include "stdafx.h"
#include "checknx.h"
#include "checknxDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CChecknxDlg _CAO

CChecknxDlg::CChecknxDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CChecknxDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CChecknxDlg)
	m_edit_infor = _T("");
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_hIconMini =  (HICON)::LoadImage( AfxGetApp()->m_hInstance,
                MAKEINTRESOURCE(IDR_MAINFRAME), IMAGE_ICON, 16, 16,
                LR_DEFAULTCOLOR
                );
}

void CChecknxDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CChecknxDlg)
	DDX_Control(pDX, IDC_BTN_TRYNX, m_btn_trynx);
	DDX_Text(pDX, IDC_EDIT_INFOR, m_edit_infor);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CChecknxDlg, CDialog)
	//{{AFX_MSG_MAP(CChecknxDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTN_CHECKNX, OnBtnChecknx)
	ON_BN_CLICKED(IDC_BTN_TRYNX, OnBtnTrynx)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChecknxDlg bZ[W nh

BOOL CChecknxDlg::OnInitDialog()
{
	CDialog::OnInitDialog();


	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	SetIcon(m_hIconMini, FALSE);	// ACRݒ
	
	// TODO: ʂȏs͂̏ꏊɒǉĂB
	CString cstr;
	// title
	if( cstr.LoadString(IDS_STRING_TITLE) ){
		m_edit_infor = cstr + " ";
	}
	// version
	if( cstr.LoadString(IDS_STRING_VERSION) ){
		m_edit_infor += cstr + "\r\n\r\n";
	}
	// copyright
	if( cstr.LoadString(IDS_STRING_COPYRIGHT) ){
		m_edit_infor += cstr + "\r\n";
	}
	m_btn_trynx.EnableWindow(FALSE);

	UpdateData(FALSE);

	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}





void CChecknxDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	CDialog::OnSysCommand(nID, lParam);
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CChecknxDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR CChecknxDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}




void CChecknxDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
}


void CChecknxDlg::OnBtnChecknx() 
{
	CString cstr;
	CPUID_DATA cpuid;

	// 1. Is Supported CPUID?
	cstr += "1. Is Supported CPUID?           ---> ";
	if( !_cpuid( 0, &cpuid ) ){
		cstr += "Not supported.\r\n";
		goto cleanup;
	}
	cstr += "OK\r\n";

	// 2. Is Supported Extended CPUID?
	cstr += "2. Is Supported Extended CPUID?  ---> ";
	if( !_cpuid( EXTCPUID+0, &cpuid ) ){
		cstr += "ERR\r\n";
		goto cleanup;
	}
	// EAX > 0x80000000 ?
	if( !(cpuid.eax > 0x80000000) ){
		cstr += "Not supported.\r\n";
		goto cleanup;
	}
	cstr += "OK\r\n";

	// 3. Is Supported NX/XD-bit?
	cstr += "3. Is Supported NX/XD-bit?       ---> ";
	if( !_cpuid( EXTCPUID+1, &cpuid ) ){
		cstr += "ERR\r\n";
		goto cleanup;
	}
	// NX/XD-bit flag?
	if( !(cpuid.edx & FLAG_CPUID_XDbit) ){
		cstr += "Not supported.\r\n";
	}else{
		cstr += "OK\r\n";
	}

	// 4. Is Supported NX/XD-bit by OS?
	cstr += "4. Is Supported NX/XD-bit by OS? ---> ";
	if( !IsSupportedNXOS() ){
		cstr += "Not supported.\r\n";
		goto cleanup;
	}
	cstr += "OK\r\n";

	// 5. Is Enabled NX/XD-bit by OS?
	MSR_DATA msr;
	cstr += "5. Is Enabled NX/XD-bit by OS?   ---> ";

	if( _rdmsr(0xC0000080,&msr) ){
		if( msr.eax & (1<<11) ){
			cstr += "Enable\r\n";
		}else{
			cstr += "Disable\r\n";
		}
	}else{
		cstr += "Skip\r\n";
	}

	// 6. Is working Hardware DEP?
	cstr += "6. Is working Hardware DEP?      ---> ";

	if( IsFindOV() ){
		cstr += "Working!\r\n";

		// check trynx application
		CFile cf;
		if( cf.Open(FILENAME_TRYNX, CFile::modeRead ) ){
			m_btn_trynx.EnableWindow(TRUE);
			cf.Close();
			cstr += "EXTRA. Try to Execute NX error?  ---> push [Try NX!]\r\n";
		}else{
			m_btn_trynx.EnableWindow(FALSE);
		}
	}else{
		cstr += "NOT working...\r\n";
	}

cleanup:
	cstr += "\r\nfinish...\r\n";
	m_edit_infor = cstr;
	UpdateData(FALSE);

	return;
}

void CChecknxDlg::OnBtnTrynx() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	PROCESS_INFORMATION pi;
	STARTUPINFO si;

	ZeroMemory(&si, sizeof(STARTUPINFO));
	ZeroMemory(&pi, sizeof(PROCESS_INFORMATION));
				
	si.cb			= sizeof(STARTUPINFO);
	si.lpReserved	= NULL;
	si.lpDesktop	= NULL;
	si.lpTitle		= NULL;
	si.dwFlags		= STARTF_FORCEOFFFEEDBACK;
	si.cbReserved2	= 0;
	si.lpReserved2	= NULL;

	CreateProcess(
				NULL,
				FILENAME_TRYNX,
				NULL,
				NULL,
				FALSE,
				NORMAL_PRIORITY_CLASS,
				NULL,
				NULL,
				&si, &pi);

	if(NULL!=pi.hProcess){ CloseHandle(pi.hProcess); }
	if(NULL!=pi.hThread){  CloseHandle(pi.hThread);  }

	// disable [Try NX!] button
	m_btn_trynx.EnableWindow(FALSE);
	return;
}
