/*
 * x86work library
 * 05.07.24 : Makoto NARA (Mc.N)
 */

/*
 * Copyright (c) 2005 Makoto NARA (Mc.N) All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY Makoto NARA (Mc.N) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef __CPUID_H_
#define __CPUID_H_

#ifdef WIN32
#include <windows.h>
#endif


// CPUID struct
typedef struct _CPUID_DATA{
	DWORD eax;
	DWORD ebx;
	DWORD ecx;
	DWORD edx;
}CPUID_DATA, *PCPUID_DATA;

// RDMSR/WRMSR struct
typedef struct _MSR_DATA{
	DWORD edx;		// Hi
	DWORD eax;		// Lo
}MSR_DATA, *PMSR_DATA;

// extended CPUID number
#define EXTCPUID	(0x80000000)

// CPUID Flags
// AMD Processor Recognition Application Note (20734)
// CPUID(1) EDX(Feature flags)
									// from AP-485J (Intel)
#define FLAG_CPUID_FPU		(1<<0)	// I`bv̕_Zjbg
#define FLAG_CPUID_VME		(1<<1)	// z[hg
#define FLAG_CPUID_DE		(1<<2)	// fobO@\g
#define FLAG_CPUID_PSE		(1<<3)	// y[WETCYg
#define FLAG_CPUID_TSC		(1<<4)	// ^CEX^vEJE^ (RDTSC)
#define FLAG_CPUID_MSR		(1<<5)	// fŗLWX^ (RDMSR/WRMSR)
#define FLAG_CPUID_PAE		(1<<6)	// AhXg (Ɍ PAE g)
#define FLAG_CPUID_MCE		(1<<7)	// }V`FbNO

#define FLAG_CPUID_CX8		(1<<8)	// CMPXCHG8
#define FLAG_CPUID_APIC		(1<<9)	// on-chip APIC
#define FLAG_CPUID_RSV1		(1<<10)	// reserved(intel)
#define FLAG_CPUID_SEP		(1<<11)	// VXeER[ (SYSENTER/SYSEXIT)
#define FLAG_CPUID_MTRR		(1<<12)	// E^CvEWEWX^
#define FLAG_CPUID_PGE		(1<<13)	// y[WEO[oECl[u
#define FLAG_CPUID_MCA		(1<<14)	// }VE`FbNEA[LeN`
#define FLAG_CPUID_CMOV		(1<<15)	// tړ߂̃T|[g (CMOV)

#define FLAG_CPUID_PAT		(1<<16)	// y[We[u
#define FLAG_CPUID_PSE36	(1<<17)	// 36-bit page size g
#define FLAG_CPUID_PSN		(1<<18)	// Processor Serial Number
#define FLAG_CPUID_CLFSH	(1<<19)	// CLFLUSH
#define FLAG_CPUID_RSV2		(1<<20)	// reserved(intel)
#define FLAG_CPUID_DS		(1<<21)	// Debug Store
#define FLAG_CPUID_ACPI		(1<<22)	// xj^у\tgEFA䂳NbN@\̃T|[g
#define FLAG_CPUID_MMX		(1<<23)	// MMX

#define FLAG_CPUID_FXSR		(1<<24)	// _ReLXg̍Z[u^XgA
#define FLAG_CPUID_SSE		(1<<25)	// SSE
#define FLAG_CPUID_SSE2		(1<<26)	// SSE2
#define FLAG_CPUID_SS		(1<<27)	// ZtEXk[v
#define FLAG_CPUID_HTT		(1<<28)	// Hyper-Threading
#define FLAG_CPUID_TM		(1<<29)	// xj^̃T|[g
#define FLAG_CPUID_RSV3		(1<<30)	// reserved(intel)
#define FLAG_CPUID_PBE		(1<<31)	// Pending Break

// CPUID(1) ECX(Feature flags)
#define FLAG_CPUID_SSE3		(1<<0)	// SSE3
#define FLAG_CPUID_RSV4		(1<<1)	// reserved(intel)
#define FLAG_CPUID_RSV5		(1<<2)	// reserved(intel)
#define FLAG_CPUID_MONITOR	(1<<3)	// MONITOR/MWAIT
#define FLAG_CPUID_DS_CPL	(1<<4)	// CPL Qualified Debug Store
#define FLAG_CPUID_RSV6		(1<<5)
#define FLAG_CPUID_RSV7		(1<<6)
#define FLAG_CPUID_EST		(1<<7)	// Intel SpeedStep Technology
#define FLAG_CPUID_TM2		(1<<8)	// xj^Q
#define FLAG_CPUID_RSV8		(1<<9)
#define FLAG_CPUID_CID		(1<<10)	// Context ID
#define FLAG_CPUID_RSV9		(1<<11)
#define FLAG_CPUID_RSV10	(1<<12)
#define FLAG_CPUID_CX16		(1<<13)	// CMPXCHG16B
#define FLAG_CPUID_xTPR		(1<<14)	// Send Task Priority Messages

// extended CPUID(80000001) EDX
#define FLAG_CPUID_SYSCALL	(1<<11)	// SYSCALL/SYSRET (Intel)
#define FLAG_CPUID_XDbit	(1<<20)	// XD-bit (Intel)
#define FLAG_CPUID_EM64T	(1<<29)	// EM64T (Intel)

// extended CPUID(80000001) ECX
#define FLAG_CPUID_LAHF		(1<<20)	// LAHF/SAHF


#if 0
#define FLAG_CPUID_
#define FLAG_CPUID_
#define FLAG_CPUID_
#define FLAG_CPUID_
#define FLAG_CPUID_
#define FLAG_CPUID_
#define FLAG_CPUID_
#endif


#endif // __CPUINFO_H_

