/*
 * x86work library
 * 05.07.24 : Makoto NARA (Mc.N)
 */

/*
 * Copyright (c) 2005 Makoto NARA (Mc.N) All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY Makoto NARA (Mc.N) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#include "x86work.h"




BOOL
GetCPUIDVendorID(
	char*	pszVendorID,
	size_t	cb
	)
{
	CPUID_DATA cpu;

	if( pszVendorID==NULL || cb<13 ){ return FALSE; }
	// cpuid (0)
	if( !_cpuid(0,&cpu) ){ return FALSE; }

	*((DWORD*)(pszVendorID+0)) = cpu.ebx;
	*((DWORD*)(pszVendorID+4)) = cpu.edx;
	*((DWORD*)(pszVendorID+8)) = cpu.ecx;
	*(pszVendorID+12) = '\0';

	return TRUE;
}




// AP-485 Ce vZbT̎ʂCPUID  (24161819_j.pdf)
// -----
// 1. EAX=80000000h CPUID ߂sB
// 2. (EAX ɕԂꂽl) > 80000000h Ȃ΁AvZbT͊gCPUID @\T|[g
//    AT|[gĂőg@\ԍEAX ɕԂB
// 3. EAX > 80000000h(*1) Ȃ΁AvZbT̓uh@\T|[gĂB
// (*1Fp AP-485  EAX >= 80000004h ƋLڂĂ)
// -----
BOOL
GetCPUIDBrandString(
	char*	pszBrand,
	size_t	cb
	)
{
	CPUID_DATA cpu;

	if( pszBrand==NULL || cb<48 ){ return FALSE; }

	memset(pszBrand,'\0',cb);

	// cpuid (0x80000000)
	if( !_cpuid(EXTCPUID+0,&cpu) ){ return FALSE; }
	if( !(cpu.eax>0x80000000) ){
		// not supported extended CPUID
		return FALSE;
	}
	if( !(cpu.eax>=0x80000004) ){
		// not supported Brand String
		return FALSE;
	}

	// cpuid (0x80000002)
	if( !_cpuid(EXTCPUID+2,&cpu) ){ return FALSE; }
	*((DWORD*)(pszBrand+0))  = cpu.eax;
	*((DWORD*)(pszBrand+4))  = cpu.ebx;
	*((DWORD*)(pszBrand+8))  = cpu.ecx;
	*((DWORD*)(pszBrand+12)) = cpu.edx;

	// cpuid (0x80000003)
	if( !_cpuid(EXTCPUID+3,&cpu) ){ return FALSE; }
	*((DWORD*)(pszBrand+16)) = cpu.eax;
	*((DWORD*)(pszBrand+20)) = cpu.ebx;
	*((DWORD*)(pszBrand+24)) = cpu.ecx;
	*((DWORD*)(pszBrand+28)) = cpu.edx;

	// cpuid (0x80000004)
	if( !_cpuid(EXTCPUID+4,&cpu) ){ return FALSE; }
	*((DWORD*)(pszBrand+32)) = cpu.eax;
	*((DWORD*)(pszBrand+36)) = cpu.ebx;
	*((DWORD*)(pszBrand+40)) = cpu.ecx;
	*((DWORD*)(pszBrand+44)) = cpu.edx;

	*(pszBrand+47) = '\0';

	return TRUE;
}


BOOL
_cpuid(
	DWORD idx,
	PCPUID_DATA pcpu
	)
{
#ifdef WIN32
	return _cpuid_w32(idx, pcpu);
#endif // WIN32
}


BOOL
_rdmsr(
	DWORD idx,
	PMSR_DATA pmsr
	)
{
#ifdef WIN32
	return _rdmsr_w32(idx, pmsr);
#endif // WIN32
}




#if 0
#include <stdio.h>
int
main(void)
{
	char venid[100];

	if( GetCPUIDVendorID(venid, sizeof(venid)) ){
		printf("Vendor ID : [%s]\n", venid);
	}else{
		printf("not work...\n");
	}
	
	return 0;
}
#endif

