/*
 * x86work library
 * 05.07.24 : Makoto NARA (Mc.N)
 */

/*
 * Copyright (c) 2005 Makoto NARA (Mc.N) All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY Makoto NARA (Mc.N) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef __CPUINFO_H_
#define __CPUINFO_H_

#ifdef WIN32
#include <windows.h>
#endif
// cpuid structure
#include "cpuid.h"


#ifdef __cplusplus
extern "C"{
#endif


BOOL
GetCPUIDVendorID(
	char*	pszVendorID,
	size_t	cb
	);

BOOL
GetCPUIDBrandString(
	char*	pszBrand,
	size_t	cb
	);

BOOL
_cpuid(
	DWORD idx,
	PCPUID_DATA pcpu
	);

BOOL
_rdmsr(
	DWORD idx,
	PMSR_DATA pmsr
	);


#ifdef WIN32

BOOL
_cpuid_w32(
	DWORD idx,
	PCPUID_DATA pcpu
	);

BOOL
_rdmsr_w32(
	DWORD idx,
	PMSR_DATA pmsr
	);

BOOL
IsSupportedNXOS(
	void
	);

BOOL
IsFindOV(
	void
	);

#endif


#ifdef __cplusplus
}
#endif

#endif // __CPUINFO_H_


