/*
 * littleCPUID
 * 05.09.14 : Makoto NARA (Mc.N)
 */

/*
 * Copyright (c) 2005 Makoto NARA (Mc.N) All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY Makoto NARA (Mc.N) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#include "stdafx.h"
#include "littleCPUID.h"
#include "littleCPUIDDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLittleCPUIDDlg _CAO

CLittleCPUIDDlg::CLittleCPUIDDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLittleCPUIDDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLittleCPUIDDlg)
	m_edit_infor = _T("");
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_hIconMini =  (HICON)::LoadImage( AfxGetApp()->m_hInstance,
                MAKEINTRESOURCE(IDR_MAINFRAME), IMAGE_ICON, 16, 16,
                LR_DEFAULTCOLOR
                );
}

void CLittleCPUIDDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLittleCPUIDDlg)
	DDX_Control(pDX, IDC_BUTTON_3DNOWEXT, m_btn_3dnowext);
	DDX_Control(pDX, IDC_BUTTON_3DNOW, m_btn_3dnow);
	DDX_Control(pDX, IDC_BUTTON_PSN, m_btn_psn);
	DDX_Control(pDX, IDC_BUTTON_MSR, m_btn_msr);
	DDX_Control(pDX, IDC_EDIT_INFO, m_ctl_infor);
	DDX_Control(pDX, IDC_CHK_SYNCHACK, m_btn_synchack);
	DDX_Control(pDX, IDC_BUTTON_SSE3, m_btn_sse3);
	DDX_Control(pDX, IDC_BUTTON_SSE2, m_btn_sse2);
	DDX_Control(pDX, IDC_BUTTON_SSE, m_btn_sse);
	DDX_Control(pDX, IDC_BUTTON_REGISTER, m_btn_register);
	DDX_Control(pDX, IDC_BUTTON_NX, m_btn_nx);
	DDX_Control(pDX, IDC_BUTTON_MTRR, m_btn_mtrr);
	DDX_Control(pDX, IDC_BUTTON_MMX, m_btn_mmx);
	DDX_Control(pDX, IDC_BUTTON_HT, m_btn_ht);
	DDX_Control(pDX, IDC_BUTTON_EST, m_btn_est);
	DDX_Control(pDX, IDC_BUTTON_AMD64, m_btn_amd64);
	DDX_Control(pDX, IDC_COMBO_PROCESSOR, m_cmb_processor);
	DDX_Text(pDX, IDC_EDIT_INFO, m_edit_infor);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLittleCPUIDDlg, CDialog)
	//{{AFX_MSG_MAP(CLittleCPUIDDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_MMX, OnButtonMmx)
	ON_BN_CLICKED(IDC_BUTTON_SSE, OnButtonSse)
	ON_BN_CLICKED(IDC_BUTTON_SSE2, OnButtonSse2)
	ON_BN_CLICKED(IDC_BUTTON_SSE3, OnButtonSse3)
	ON_BN_CLICKED(IDC_BUTTON_PSN, OnButtonPsn)
	ON_BN_CLICKED(IDC_BUTTON_MTRR, OnButtonMtrr)
	ON_BN_CLICKED(IDC_BUTTON_AMD64, OnButtonAmd64)
	ON_BN_CLICKED(IDC_BUTTON_NX, OnButtonNx)
	ON_BN_CLICKED(IDC_BUTTON_EST, OnButtonEst)
	ON_BN_CLICKED(IDC_BUTTON_HT, OnButtonHt)
	ON_CBN_SELCHANGE(IDC_COMBO_PROCESSOR, OnSelchangeComboProcessor)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, OnButtonClear)
	ON_BN_CLICKED(IDC_BUTTON_COPY, OnButtonCopy)
	ON_BN_CLICKED(IDC_BUTTON_REGISTER, OnButtonRegister)
	ON_BN_CLICKED(IDC_BUTTON_MSR, OnButtonMsr)
	ON_BN_CLICKED(IDC_BUTTON_3DNOW, OnButton3dnow)
	ON_BN_CLICKED(IDC_BUTTON_3DNOWEXT, OnButton3dnowext)
	ON_BN_CLICKED(IDC_BUTTON_ABOUT, OnButtonAbout)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLittleCPUIDDlg bZ[W nh

BOOL CLittleCPUIDDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);				// 傫ACRݒ
	SetIcon(m_hIconMini, FALSE);		// ACRݒ
	
	// TODO: ʂȏs͂̏ꏊɒǉĂB
	// init cpuid information data
	pcpu = OpenCPUIDinfo();
	// init Processor
	initProcessor();

	UpdateData(FALSE);
	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

void CLittleCPUIDDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	if( NULL!=pcpu ){
		CloseCPUIDinfo(pcpu); 
		pcpu = NULL;
	}
}

void CLittleCPUIDDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	CDialog::OnSysCommand(nID, lParam);
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CLittleCPUIDDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR CLittleCPUIDDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CLittleCPUIDDlg::initProcessor()
{
	CString cstr;
	DWORD num;

	// init processor disp
	m_cmb_processor.ResetContent();

	if( NULL==pcpu ){
		// non-processor... :-(
		m_cmb_processor.InsertString(0, "(none)");
		m_cmb_processor.SetCurSel(0);
		disableProcessor();		// disable processor
		return;
	}
	num = GetProcessorNum( pcpu );
	if( 1==num ){
		// single processor
		m_cmb_processor.InsertString(0, "Processor(Single)");
	}else{
		// multi-processor
		DWORD core;
		BOOL  bLog;
		for( DWORD i=0; i<num; i++ ){
			core = GetMultiCoreNum(pcpu,i);
			bLog = IsLogicalProcessor(pcpu,i);
			if( core > 1 ){
				// multicore
				if(bLog){
					cstr.Format("Processor#[%d/%d] (core(%d), logical)", i+1, num, core);
				}else{
					cstr.Format("Processor#[%d/%d] (core(%d))", i+1, num, core);
				}
			}else{
				// single core
				if(bLog){
					cstr.Format("Processor#[%d/%d] (logical)", i+1, num);	// Logical Processor (HTT)
				}else{
					cstr.Format("Processor#[%d/%d]", i+1, num);
				}
			}
			
			m_cmb_processor.InsertString(i, cstr);
		}
	}

	m_cmb_processor.SetCurSel(0);
	refreshProcessor(0);	// Set processor# -> 0
	return;
}

void CLittleCPUIDDlg::refreshProcessor(DWORD iP)
{
	if( NULL==pcpu ){ disableProcessor(); return; }
	if( GetProcessorNum(pcpu)<=iP ){ disableProcessor(); return; }

	// control button -> Enable
	m_btn_register.EnableWindow();
	m_btn_synchack.EnableWindow();

	// Check feature flag
	if( IsFeature(pcpu,iP,FLAG_CPUID_MMX)  ){m_btn_mmx.EnableWindow();}else{m_btn_mmx.EnableWindow(FALSE);}		// MMX
	if( IsFeature(pcpu,iP,FLAG_CPUID_SSE)  ){m_btn_sse.EnableWindow();}else{m_btn_sse.EnableWindow(FALSE);}		// SSE
	if( IsFeature(pcpu,iP,FLAG_CPUID_SSE2) ){m_btn_sse2.EnableWindow();}else{m_btn_sse2.EnableWindow(FALSE);}	// SSE2
	if( IsFeature(pcpu,iP,FLAG_CPUID_SSE3) ){m_btn_sse3.EnableWindow();}else{m_btn_sse3.EnableWindow(FALSE);}	// SSE3
	if( IsFeature(pcpu,iP,FLAG_CPUID_PSN)  ){m_btn_psn.EnableWindow();}else{m_btn_psn.EnableWindow(FALSE);}		// PSN
	if( IsFeature(pcpu,iP,FLAG_CPUID_MTRR) ){m_btn_mtrr.EnableWindow();}else{m_btn_mtrr.EnableWindow(FALSE);}	// MTRR
	if( IsFeature(pcpu,iP,FLAG_CPUID_EM64T)){m_btn_amd64.EnableWindow();}else{m_btn_amd64.EnableWindow(FALSE);}	// AMD64/EM64T
	if( IsFeature(pcpu,iP,FLAG_CPUID_XDbit)){m_btn_nx.EnableWindow();}else{m_btn_nx.EnableWindow(FALSE);}		// NX/XD
	if( IsFeature(pcpu,iP,FLAG_CPUID_EST)  ){m_btn_est.EnableWindow();}else{m_btn_est.EnableWindow(FALSE);}		// EIST
	if( IsFeature(pcpu,iP,FLAG_CPUID_HTT)  ){m_btn_ht.EnableWindow();}else{m_btn_ht.EnableWindow(FALSE);}		// HTT
	if( IsFeature(pcpu,iP,FLAG_CPUID_3DNOW)){m_btn_3dnow.EnableWindow();}else{m_btn_3dnow.EnableWindow(FALSE);}	// 3DNow!
	if( IsFeature(pcpu,iP,FLAG_CPUID_3DNOWEXT)){m_btn_3dnowext.EnableWindow();}else{m_btn_3dnowext.EnableWindow(FALSE);}	// 3DNow! ext.
	

	// display Processor Signature
	m_edit_infor = "[Processor Summary Information]:\r\n";
	CString cstr;

	// F/M/S
	DWORD efml, emdl, pt, fml, mdl, stp = 0;
	if( GetProcessorData(pcpu,iP,CPUID_EXTENDED_FAMILY,&efml) &&
		GetProcessorData(pcpu,iP,CPUID_EXTENDED_MODEL, &emdl) &&
		GetProcessorData(pcpu,iP,CPUID_PROCESSOR_TYPE, &pt  ) &&
		GetProcessorData(pcpu,iP,CPUID_FAMILY_CODE,    &fml ) &&
		GetProcessorData(pcpu,iP,CPUID_MODEL_NUMBER,   &mdl ) &&
		GetProcessorData(pcpu,iP,CPUID_STEPPING_ID,    &stp ) ){
		cstr.Format("Family/Model/Step       : %d/%d/%d\r\n", fml,mdl,stp);
		m_edit_infor += cstr;
		m_edit_infor += "Type/Ex.Family/Ex.Model : ";
		switch(pt){
		case 0:  cstr = "00/"; break;
		case 1:  cstr = "01/"; break;
		case 2:  cstr = "10/"; break;
		case 3:  cstr = "11/"; break;
		default: cstr = "--/"; break;
		}
		m_edit_infor += cstr;
		cstr.Format("%d/%d\r\n", efml,emdl);
		m_edit_infor += cstr;
	}else{
		m_edit_infor += "F/M/S error...\r\n";
	}

	// Multiprocessor
	dispMultiprocessor(iP);

	UpdateData(FALSE);
	return;
}

void CLittleCPUIDDlg::dispMultiprocessor(DWORD iP)
{
	CString cstr;

	// Multiprocessor
	m_edit_infor += "Multi-processor info.   : ";
	DWORD lapic, llp;
	if( GetProcessorData(pcpu,iP,CPUID_LOCAL_APIC, &lapic) &&
		GetProcessorData(pcpu,iP,CPUID_LOGICAL_PROCESSOR_NUM, &llp )){
		if( CPUVENDOR_INTEL == GetCPUVendor(pcpu) ){
			// intel
			if( IsFeature(pcpu,iP,FLAG_CPUID_HTT) && llp>1 ){
				// Enable Hyper-Threading Technology
				int i;
				for(i=0;((DWORD)1<<i)<llp;i++);
				cstr.Format("LocalAPIC:[%d], PHY ID:[%d], LOG ID:[%d]\r\n",
					lapic,
					lapic>>i,
					lapic&~(0xFFFFFFFF<<i) );
				m_edit_infor += cstr;
			}else{
				// non-HTT
				cstr.Format("LocalAPIC:[%d]\r\n", lapic);
				m_edit_infor += cstr;
			}
		}else if( CPUVENDOR_AMD == GetCPUVendor(pcpu) ){
			// AMD
			cstr.Format("LocalAPIC:[%d]\r\n", lapic);
			m_edit_infor += cstr;
		}else{
			// other CPU
			cstr.Format("LocalAPIC:[%d]\r\n", lapic);
			m_edit_infor += cstr;
		}

	}
	return;
}




void CLittleCPUIDDlg::disableProcessor()
{
	m_btn_register.EnableWindow(FALSE);
	m_btn_synchack.EnableWindow(FALSE);
	m_btn_mmx.EnableWindow(FALSE);		// MMX
	m_btn_sse.EnableWindow(FALSE);		// SSE
	m_btn_sse2.EnableWindow(FALSE);		// SSE2
	m_btn_sse3.EnableWindow(FALSE);		// SSE3
	m_btn_psn.EnableWindow(FALSE);		// PSN
	m_btn_mtrr.EnableWindow(FALSE);		// MTRR
	m_btn_amd64.EnableWindow(FALSE);	// AMD64/EM64T
	m_btn_nx.EnableWindow(FALSE);		// NX/XD
	m_btn_est.EnableWindow(FALSE);		// EIST
	m_btn_ht.EnableWindow(FALSE);		// HTT
	m_btn_3dnow.EnableWindow(FALSE);	// 3DNow!
	m_btn_3dnowext.EnableWindow(FALSE);	// 3DNow! ext
	return;
}

void CLittleCPUIDDlg::OnButtonMmx()  {dispFlagInfo(FLAG_CPUID_MMX);}
void CLittleCPUIDDlg::OnButtonSse()  {dispFlagInfo(FLAG_CPUID_SSE);}
void CLittleCPUIDDlg::OnButtonSse2() {dispFlagInfo(FLAG_CPUID_SSE2);}
void CLittleCPUIDDlg::OnButtonSse3() {dispFlagInfo(FLAG_CPUID_SSE3);}
void CLittleCPUIDDlg::OnButtonPsn()  {dispFlagInfo(FLAG_CPUID_PSN);}
void CLittleCPUIDDlg::OnButtonMtrr() {dispFlagInfo(FLAG_CPUID_MTRR);}
void CLittleCPUIDDlg::OnButtonAmd64(){dispFlagInfo(FLAG_CPUID_EM64T);}
void CLittleCPUIDDlg::OnButtonNx()   {dispFlagInfo(FLAG_CPUID_XDbit);}
void CLittleCPUIDDlg::OnButtonEst()  {dispFlagInfo(FLAG_CPUID_EST);}
void CLittleCPUIDDlg::OnButtonHt()   {dispFlagInfo(FLAG_CPUID_HTT);}
void CLittleCPUIDDlg::OnButtonMsr()  {dispFlagInfo(FLAG_CPUID_MSR);}
void CLittleCPUIDDlg::OnButton3dnow(){dispFlagInfo(FLAG_CPUID_3DNOW);}
void CLittleCPUIDDlg::OnButton3dnowext() {dispFlagInfo(FLAG_CPUID_3DNOWEXT);}


void CLittleCPUIDDlg::dispFlagInfo(DWORD feature)
{
	CString cstr;
	BOOL bRet;

	if( m_btn_synchack.GetState()&0x3 ){
		// connect SyncHack!
		cstr = "http://mcn.oops.jp/wiki/index.php?CPU%2FCPUID%2F";
		bRet = TRUE;

		switch(feature){
		case FLAG_CPUID_MMX:	cstr += "MMX"; break;
		case FLAG_CPUID_SSE:	cstr += "SSE"; break;
		case FLAG_CPUID_SSE2:	cstr += "SSE2"; break;
		case FLAG_CPUID_SSE3:	cstr += "SSE3"; break;
		case FLAG_CPUID_PSN:	cstr += "PSN"; break;
		case FLAG_CPUID_MTRR:	cstr += "MTRR"; break;
		case FLAG_CPUID_EM64T:	cstr += "X64"; break;
		case FLAG_CPUID_XDbit:	cstr += "NX"; break;
		case FLAG_CPUID_EST:	cstr += "EST"; break;
		case FLAG_CPUID_HTT:	cstr += "HTT"; break;
		case FLAG_CPUID_MSR:	cstr += "MSR"; break;
		case FLAG_CPUID_3DNOW:	cstr += "3DNOW"; break;
		case FLAG_CPUID_3DNOWEXT: cstr += "3DNOWEXT"; break;
		default:				bRet = FALSE; break;
		}
		if(bRet){
			HINSTANCE hSE = 0;
			hSE = ShellExecute( NULL, "open", cstr, NULL, NULL, SW_SHOWNORMAL );
			if( hSE < (HINSTANCE)32 ){
				bRet = FALSE;
			}
		}
		// result display
		if(bRet){
			m_edit_infor = "[Feature]: no probrem, connection SyncHack!\r\n  " + cstr + "\r\n";
		}else{
			m_edit_infor = "[Feature]: error\r\n";
		}
	}else{
		// local display
		switch(feature){
		case FLAG_CPUID_MMX:	cstr = "MMX(MultiMedia eXtension) :\r\nIntel ЂJ}`fBAnߌQB\r\nPentium ̗pB"; break;
		case FLAG_CPUID_SSE:	cstr = "SSE(Streaming SIMD Extensions) :\r\nMMX ̕_ŁBPentium III(Katmai) ̗pB"; break;
		case FLAG_CPUID_SSE2:	cstr = "SSE2(Streaming SIMD Extensions 2) :\r\nSSE ̊gŁBߌQĂBP4 ̗pB"; break;
		case FLAG_CPUID_SSE3:	cstr = "SSE3(Streaming SIMD Extensions 3) :\r\nSSE2 ̊gŁBߌQĂBP4(Prescott) ̗pB"; break;
		case FLAG_CPUID_PSN:	cstr = "PSN(Processor Serial Number) :\r\nProcessor ŗLԍBP3 ō̗p P4 Ŕp~B"; break;
		case FLAG_CPUID_MTRR:	cstr = "MTRR(Memory Type Range Register) :\r\nMemory ̎ނwBPPro ̗pB"; break;
		case FLAG_CPUID_EM64T:	cstr = "X64(AMD64/EM64T) :\r\nx32  64-bit gBAMD JAȌ Intel Ǐ]B"; break;
		case FLAG_CPUID_XDbit:	cstr = "NX(NX-bit/XD-bit) :\r\nf[^sh~@\BAMD JAȌ Intel Ǐ]B"; break;
		case FLAG_CPUID_EST:	cstr = "EST(Enhanced Intel SpeedStep Technology) :\r\nSpeedStep ̊gŁB"; break;
		case FLAG_CPUID_HTT:	cstr = "HTT(Hyper-Threading Technology) :\r\n_vZbTB"; break;
		case FLAG_CPUID_MSR:	cstr = "MSR(Model-Specific Register) :\r\nfŗLWX^BPentium B"; break;
		case FLAG_CPUID_3DNOW:	cstr = "3DNow! :\r\nSSE  AMD ŁB"; break;
		case FLAG_CPUID_3DNOWEXT: cstr = "3DNow! :\r\n3DNow! ̊gŁB"; break;
		default:				cstr = "Internal Error..."; break;
		}
		m_edit_infor = "[Feature]: little information feature flag...\r\n-----\r\n" + cstr + "\r\n";

	}
	UpdateData(FALSE);
	return;
}


void CLittleCPUIDDlg::OnSelchangeComboProcessor() 
{
	refreshProcessor(m_cmb_processor.GetCurSel());
	return;
}


void CLittleCPUIDDlg::OnButtonClear() 
{
	m_edit_infor.Empty();
	UpdateData(FALSE);
	return;
}

void CLittleCPUIDDlg::OnButtonCopy() 
{
	m_ctl_infor.SetSel(0,-1,TRUE);
	m_ctl_infor.Copy();
	m_ctl_infor.SetSel(-1,-1,TRUE);
	return;
}

void CLittleCPUIDDlg::OnButtonRegister() 
{
	// All register dump for Debug
	if( NULL==pcpu ){
		disableProcessor();
		m_edit_infor = "[Register] : internal error...";
		UpdateData(FALSE);
		return;
	}

	PCPUIDS_DATA pcpus;
	DWORD cnt = 0xFFFFFFFF;
	CString cstr;

	m_edit_infor = "[Register] : CPUID Register dump program\r\n";
	cstr.Format( "Processor # : [%d]\r\n", GetProcessorNum(pcpu) ); m_edit_infor += cstr;
	cstr.Format( "dwVendor    : [%d]\r\n", GetCPUVendor(pcpu) );    m_edit_infor += cstr;
	cstr = "Vendor ID   : ["; m_edit_infor += cstr + GetVendorID(pcpu) + "]\r\n";
	cstr = "Brand String: ["; m_edit_infor += cstr + GetVendorString(pcpu) + "]\r\n";
	m_edit_infor += "\r\n";

	for(pcpus=pcpu->pcpus; NULL!=pcpus; pcpus=pcpus->pnext){
		if( cnt != pcpus->cpu.cntcpu ){
			cnt = pcpus->cpu.cntcpu;
			m_edit_infor += "==========\r\n";
			cstr.Format("Count CPU = [%d], Process num = [%d]\r\n", pcpus->cpu.cntcpu, pcpus->cpu.numcpu ); m_edit_infor += cstr;
			dispMultiprocessor(cnt);
			m_edit_infor += "----------\r\n";
		}
		cstr.Format("idx=[%08X], eax=[%08X], ebx=[%08X], ecx=[%08X], edx=[%08X]\r\n", pcpus->cpu.idx, pcpus->cpu.eax, pcpus->cpu.ebx, pcpus->cpu.ecx, pcpus->cpu.edx );
		m_edit_infor += cstr;
	}

	UpdateData(FALSE);
	return;
}

void CLittleCPUIDDlg::OnButtonAbout() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CString cstr;
	// title
	if( cstr.LoadString(IDS_STRING_TITLE) ){
		m_edit_infor = cstr + " ";
	}
	// version
	if( cstr.LoadString(IDS_STRING_VERSION) ){
		m_edit_infor += cstr + "\r\n";
	}
	// copyright
	if( cstr.LoadString(IDS_STRING_COPYRIGHT) ){
		m_edit_infor += cstr + "\r\n";
	}

	UpdateData(FALSE);
	return;
}
