/*
 * x86work library
 * 05.07.24 : Makoto NARA (Mc.N)
 */

/*
 * Copyright (c) 2005 Makoto NARA (Mc.N) All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY Makoto NARA (Mc.N) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef __CPUID_H_
#define __CPUID_H_

// CPUID struct
typedef struct _CPUID_DATA{
	DWORD numcpu;	// processor #
	DWORD cntcpu;	// count processor
	DWORD idx;		// index #
	DWORD eax;
	DWORD ebx;
	DWORD ecx;
	DWORD edx;
}CPUID_DATA, *PCPUID_DATA;

// raw CPUIDs struct
typedef struct _CPUIDS_DATA{
	struct _CPUIDS_DATA *pnext;
	CPUID_DATA cpu;
}CPUIDS_DATA, *PCPUIDS_DATA;

#define CPUVENDOR_UNKNOWN	(0)
#define CPUVENDOR_INTEL		(1)
#define CPUVENDOR_AMD		(2)
//#define CPUVENDOR_
#define MAX_VENDORID		(13)
#define MAX_BRANDSTRING		(48)

// standard CPUID struct
typedef struct _CPUID_INFOR{
	PCPUIDS_DATA pcpus;
	DWORD dwProcessor;
	DWORD dwVendor;
	BYTE  szVendorID[MAX_VENDORID];
	BYTE  szBrand[MAX_BRANDSTRING];
} CPUID_INFOR, *PCPUID_INFOR;




// RDMSR/WRMSR struct
typedef struct _MSR_DATA{
	DWORD edx;		// Hi
	DWORD eax;		// Lo
}MSR_DATA, *PMSR_DATA;

// extended CPUID number
#define EXTCPUID	(0x80000000)


// AMD Processor Recognition Application Note (20734)
// AP-485J (Intel)

// CPUID Flags
// ------bb : bit shift (1<<xx) xx=0~31
// ----rr-- : register(eax=0, ebx=1, ecx=2, edx=3 )
// --ii---- : index (CPUID(1)=0, CPUID(80000001)=1)
// vv------ : vendor (Standard=0, Intel=1, AMD=2)

#define FLAG_CPUID_BITSHIFT	(0xFF)

#define FLAG_CPUID_FLT_REG	(0xFF00)		
#define FLAG_CPUID_REG_EAX	(0x0000)	// EAX
#define FLAG_CPUID_REG_EBX	(0x0100)	// EBX
#define FLAG_CPUID_REG_ECX	(0x0200)	// ECX
#define FLAG_CPUID_REG_EDX	(0x0300)	// EDX

#define FLAG_CPUID_FLT_IDX	(0xFF0000)
#define FLAG_CPUID_IDX_1	(0x000000)	// CPUID(1)
#define FLAG_CPUID_IDX_E1	(0x010000)	// CPUID(80000001)

#define FLAG_CPUID_FLT_VENDOR	(0xFF000000)
#define FLAG_CPUID_VEN_STD		(0x00000000)
#define FLAG_CPUID_VEN_INTEL	(0x01000000)
#define FLAG_CPUID_VEN_AMD		(0x02000000)


// CPUID(1) EDX(Feature flags)
#define FLAG_CPUID_FPU		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 0)		// I`bv̕_Zjbg
#define FLAG_CPUID_VME		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 1)		// z[hg
#define FLAG_CPUID_DE		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 2)		// fobO@\g
#define FLAG_CPUID_PSE		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 3)		// y[WETCYg
#define FLAG_CPUID_TSC		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 4)		// ^CEX^vEJE^ (RDTSC)
#define FLAG_CPUID_MSR		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 5)		// fŗLWX^ (RDMSR/WRMSR)
#define FLAG_CPUID_PAE		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 6)		// AhXg (Ɍ PAE g)
#define FLAG_CPUID_MCE		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 7)		// }V`FbNO

#define FLAG_CPUID_CX8		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 8)		// CMPXCHG8
#define FLAG_CPUID_APIC		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 9)		// on-chip APIC
#define FLAG_CPUID_RSV1		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 10)		// reserved(intel)
#define FLAG_CPUID_SEP		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 11)		// VXeER[ (SYSENTER/SYSEXIT)
#define FLAG_CPUID_MTRR		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 12)		// E^CvEWEWX^
#define FLAG_CPUID_PGE		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 13)		// y[WEO[oECl[u
#define FLAG_CPUID_MCA		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 14)		// }VE`FbNEA[LeN`
#define FLAG_CPUID_CMOV		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 15)		// tړ߂̃T|[g (CMOV)

#define FLAG_CPUID_PAT		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 16)		// y[We[u
#define FLAG_CPUID_PSE36	(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 17)		// 36-bit page size g
#define FLAG_CPUID_PSN		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 18)		// Processor Serial Number
#define FLAG_CPUID_CLFSH	(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 19)		// CLFLUSH
#define FLAG_CPUID_RSV2		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 20)		// reserved(intel)
#define FLAG_CPUID_DS		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 21)		// Debug Store
#define FLAG_CPUID_ACPI		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 22)		// xj^у\tgEFA䂳NbN@\̃T|[g
#define FLAG_CPUID_MMX		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 23)		// MMX

#define FLAG_CPUID_FXSR		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 24)		// _ReLXg̍Z[u^XgA
#define FLAG_CPUID_SSE		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 25)		// SSE
#define FLAG_CPUID_SSE2		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 26)		// SSE2
#define FLAG_CPUID_SS		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 27)		// ZtEXk[v
#define FLAG_CPUID_HTT		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 28)		// Hyper-Threading
#define FLAG_CPUID_TM		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 29)		// xj^̃T|[g
#define FLAG_CPUID_RSV3		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 30)		// reserved(intel)
#define FLAG_CPUID_PBE		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_EDX | 31)		// Pending Break

// CPUID(1) ECX(Feature flags)
#define FLAG_CPUID_SSE3		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_ECX | 0)		// SSE3
#define FLAG_CPUID_RSV4		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_ECX | 1)		// reserved(intel)
#define FLAG_CPUID_RSV5		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_ECX | 2)		// reserved(intel)
#define FLAG_CPUID_MONITOR	(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_ECX | 3)		// MONITOR/MWAIT
#define FLAG_CPUID_DS_CPL	(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_ECX | 4)		// CPL Qualified Debug Store
#define FLAG_CPUID_RSV6		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_ECX | 5)
#define FLAG_CPUID_RSV7		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_ECX | 6)
#define FLAG_CPUID_EST		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_ECX | 7)		// g SpeedStep Technology (EIST)
#define FLAG_CPUID_TM2		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_ECX | 8)		// xj^Q
#define FLAG_CPUID_RSV8		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_ECX | 9)
#define FLAG_CPUID_CID		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_ECX | 10)		// Context ID
#define FLAG_CPUID_RSV9		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_ECX | 11)
#define FLAG_CPUID_RSV10	(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_ECX | 12)
#define FLAG_CPUID_CX16		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_ECX | 13)		// CMPXCHG16B
#define FLAG_CPUID_xTPR		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_1 | FLAG_CPUID_REG_ECX | 14)		// Send Task Priority Messages

// extended CPUID(80000001) EDX
#define FLAG_CPUID_SYSCALL	(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_E1 | FLAG_CPUID_REG_EDX | 11)	// SYSCALL/SYSRET (AMD/Intel)
#define FLAG_CPUID_XDbit	(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_E1 | FLAG_CPUID_REG_EDX | 20)	// XD-bit (Intel)
#define FLAG_CPUID_AMDMMX	(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_E1 | FLAG_CPUID_REG_EDX | 22)	// AMD extensions MMX (AMD)
#define FLAG_CPUID_FFXSR	(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_E1 | FLAG_CPUID_REG_EDX | 25)	// Fast FXSAVE and FXRSTOR (AMD)
#define FLAG_CPUID_EM64T	(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_E1 | FLAG_CPUID_REG_EDX | 29)	// EM64T (Intel), Long mode/AMD64 (AMD)
#define FLAG_CPUID_3DNOWEXT	(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_E1 | FLAG_CPUID_REG_EDX | 30)	// Extensions to 3DNow! (AMD)
#define FLAG_CPUID_3DNOW	(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_E1 | FLAG_CPUID_REG_EDX | 31)	// 3DNow! (AMD)


// extended CPUID(80000001) ECX
#define FLAG_CPUID_LAHF4L	(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_E1 | FLAG_CPUID_REG_ECX | 0)	// LAHF/SAHF for Long mode(AMD) 
#define FLAG_CPUID_CMPLegacy (FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_E1 | FLAG_CPUID_REG_ECX | 1)	// core muti-processing legacy mode (AMD) 
#define FLAG_CPUID_LAHF		(FLAG_CPUID_VEN_STD | FLAG_CPUID_IDX_E1 | FLAG_CPUID_REG_ECX | 20)	// LAHF/SAHF (Intel)


//#define FLAG_CPUID_





#endif // __CPUID_H_

