/* disp.c - display information for console
 *
 * Copyright (c) 1998-2000 Mc.N(Makoto NARA)
 * For conditions of distribution and use, see copyright notice in smart2k.h 
 *
 */

#ifdef _CONSOLE
#include "smart2k.h"

// [81] (ATA-3) Minor version number
CHAR* minor_version[] ={
	"Obsolete",										// 0
	"Obsolete",										// 1
	"Obsolete",										// 2
	"Obsolete",										// 3
	"ATA-2 published, ANSI X3.279-1996",			// 4
	"ATA-2 X3T10 948D prior to revision 2k",		// 5
	"ATA-3 X3T10 2008D revision 1",					// 6
	"ATA-2 X3T10 948D revision 2k",					// 7
	"ATA-3 X3T10 2008D revision 0",					// 8
	"ATA-2 X3T10 948D revision 3",					// 9
	"ATA-3 published, ANSI X3.298-199x",			// A
	"ATA-3 X3T10 2008D revision 6",					// B
	"ATA-3 X3T13 2008D revision 7 and 7a",			// C
	"ATA/ATAPI-4 X3T13 1153D revision 6",			// D
	"ATA/ATAPI-4 T13 1153D revision 13",			// E
	"ATA/ATAPI-4 X3T13 1153D revision 7",			// F
	"ATA/ATAPI-4 T13 1153D revision 18",			// 10
	"ATA/ATAPI-4 T13 1153D revision 15",			// 11
	"ATA/ATAPI-4 published, ANSI NCITS 317-1998",	// 12
	"ATA/ATAPI-5 T13 1321D revision 3",				// 13
	"ATA/ATAPI-4 T13 1153D revision 14",			// 14
	"ATA/ATAPI-5 T13 1321D revision 1",				// 15
	"Reserved",										// 16
	"ATA/ATAPI-4 T13 1153D revision 17",			// 17
	"ATA/ATAPI-6 T13 1410D revision 0"				// 18
};


/* P-R-O-T-O-T-Y-P-E */


VOID
DispSmartIdentifyDump(
	PATA_INDENTIFYDATA pidentify
	);

VOID
DispSmartByteDump(
	PBYTE pb,
	INT   cbSize
	);

VOID
DispSmartIdentifySummary(
	PATA_INDENTIFYDATA pidentify
	);

VOID
DispSmartIdentifyDetail(
	PATA_INDENTIFYDATA pidentify
	);

VOID
DispDefaultTransferMode(
	PATA_INDENTIFYDATA pidentify
	);

VOID
DispSmartDeviceAttribute(
	PATA_ATTRIBUTEDATA	pattrib,
	PATA_THRESHOLDSDATA	pthresholds
	);


/* F-U-N-C-T-I-O-N */


BOOL
DispSmartReturnStatus(
	BYTE num,
	INT  iLevel
	)
{
	HANDLE	hSmart;
	BYTE	bDeviceNum;
	GETVERSIONINPARAMS getver;
	BOOL bRet;

	if( num == ENUM_ALLDRIVE &&	iLevel != DISPLEVEL_NONE){
		printf("Error : Empty parameter, -ata[num]\n");
		return FALSE;
	}

	hSmart = SmartGetHandle( num, &bDeviceNum, &getver );
	if( hSmart == INVALID_HANDLE_VALUE ){
		if( iLevel != DISPLEVEL_NONE ){
			printf("Error : Can't open handle [ata%d]\n", num);
		}
		return FALSE;
	}

	bRet = SmartATAReturnStatus(hSmart, bDeviceNum);
	CloseHandle(hSmart);

	if( iLevel == DISPLEVEL_NONE ){
		return bRet;
	}

	if( bRet ){
		printf("Success : SMART RETURN STATUS is GOOD status\n");
	}else{
		printf("Probrem? : SMART RETURN STATUS is BUD status\n");
	}

	return bRet;
}


BOOL
DispSmartEnableDisableOperation(
	BYTE num,
	BOOL bOp,
	INT  iLevel
	)
{
	HANDLE	hSmart;
	BYTE	bDeviceNum;
	GETVERSIONINPARAMS getver;
	BOOL bRet;
	PCHAR pStr;

	if( num == ENUM_ALLDRIVE &&	iLevel != DISPLEVEL_NONE){
		printf("Error : Empty parameter, -ata[num]\n");
		return FALSE;
	}

	hSmart = SmartGetHandle( num, &bDeviceNum, &getver );
	if( hSmart == INVALID_HANDLE_VALUE ){
		if( iLevel != DISPLEVEL_NONE ){
			printf("Error : Can't open handle [ata%d]\n", num);
		}
		return FALSE;
	}

	if( bOp ){
		bRet = SmartATAEnableDisableOperation( hSmart, bDeviceNum, TRUE );
		if( bRet ){
			SmartATAEnableDisableAutosave( hSmart, bDeviceNum, TRUE );
		}
	}else{
		bRet = SmartATAEnableDisableOperation( hSmart, bDeviceNum, FALSE );
	}
	CloseHandle(hSmart);

	if( iLevel == DISPLEVEL_NONE ){
		return bRet;
	}

	if( bOp ){
		pStr = "SMART ENABLE OPERATIONS";
	}else{
		pStr = "SMART DISABLE OPERATIONS";
	}

	if( bRet ){
		printf("Success : %s is successed\n", pStr);
	}else{
		printf("Error : %s is false\n", pStr);
	}

	return bRet;
}


VOID
DispSmartReadThresholds(
	PATA_THRESHOLDSDATA	pthresholds,
	INT					iLevel
	)
{
	switch( iLevel ){
	case DISPLEVEL_NONE:
		break;
	case DISPLEVEL_DEBUG:
		printf("SMART Attributes Thresholds raw dump :\n");
		DispSmartByteDump( (PBYTE)pthresholds, sizeof(ATA_THRESHOLDSDATA) );
		break;
	case DISPLEVEL_SUMMARY:
		break;
	case DISPLEVEL_DETAIL:
		break;
	default:
		break;
	}

	return;
}


VOID
DispSmartReadAttribute(
	PATA_ATTRIBUTEDATA	pattrib,
	INT					iLevel
	)
{
	switch( iLevel ){
	case DISPLEVEL_NONE:
		break;
	case DISPLEVEL_DEBUG:
		printf("SMART Attributes(READ DATA) raw dump :\n");
		DispSmartByteDump( (PBYTE)pattrib, sizeof(ATA_ATTRIBUTEDATA) );
		break;
	case DISPLEVEL_SUMMARY:
		break;
	case DISPLEVEL_DETAIL:
		break;
	default:
		break;
	}

	return;
}


VOID
DispSmartIdentify(
	PATA_INDENTIFYDATA	pidentify,
	INT					iLevel
	)
{
	switch( iLevel ){
	case DISPLEVEL_NONE:
		break;
	case DISPLEVEL_DEBUG:
		DispSmartIdentifyDetail(pidentify);
		DispSmartIdentifyDump(pidentify);
		break;
	case DISPLEVEL_SUMMARY:
		DispSmartIdentifySummary(pidentify);
		break;
	case DISPLEVEL_DETAIL:
		DispSmartIdentifyDetail(pidentify);
		break;
	default:
		break;
	}

	return;
}


VOID
DispSmartVersion(
	PGETVERSIONINPARAMS pgetver,
	INT					iLevel
	)
{
	switch( iLevel ){
	case DISPLEVEL_NONE:
		break;
	case DISPLEVEL_DEBUG:
		printf( "SMART function version :\n  " );
		printf( "version [%d.%02d], ", pgetver->bVersion, pgetver->bRevision );
		printf( "bIDEDeviceMap[0x%x], ",  pgetver->bIDEDeviceMap );
		printf( "fCapabilities : [0x%x]\n", pgetver->fCapabilities );
		printf("\n");
		break;
	default:
		break;
	}

	return;
}


VOID
DispSmartIdentifySummary(
	PATA_INDENTIFYDATA pidentify
	)
{
	BYTE	szModel[1024];
	double	ddSize;
	DWORD	*dwLba;
	int		i;

	// model number
 	word2str((char*)pidentify->model_number, sizeof(pidentify->model_number), szModel);
	for( i=0; i<sizeof(pidentify->model_number); i++ ){
		if( szModel[i] == ' ' && szModel[i+1] == ' ' ){
			szModel[i] = '\0';
			break;
		}
	}
	printf("%s ", szModel);

	// Disk size	
	dwLba = (DWORD*)pidentify->total_sector;
	ddSize = (double)(*dwLba >> 11) / (double)1024;
	printf("(%.1fGB, ", ddSize);

	// default transfer mode
//	DispDefaultTransferMode(pidentify);

	// Is SMART supported?
	if( IsSmartSupported(pidentify) ){
		printf("SMART is supported");
	}else{
		printf("SMART is NOT supported");
	}
	printf(")\n");

	return;
}


VOID
DispSmartIdentifyDetail(
	PATA_INDENTIFYDATA pidentify
	)
{
	ULONGLONG ullSize;
	DWORD	*dwTmp;
	double	ddSize;
	int		i;
	BOOL	bMinus;
	BYTE	szTemp[1024];

	printf("ATA Identify Detail :\n");
	printf("---\n");

	// model number
 	word2str((char*)pidentify->model_number, sizeof(pidentify->model_number), szTemp);
	printf("Model: %s\n", szTemp);

	// serial number
	word2str((char*)pidentify->serial_number, sizeof(pidentify->serial_number), szTemp);
	printf("Serial: %s\n", szTemp);

	// Firmware revision
	word2str((char*)pidentify->firmware, sizeof(pidentify->firmware), szTemp);
	printf("Firmware: %s\n", szTemp);

	printf("---\n");
	// CHS type
	if( pidentify->word_valid & WORD53_VALIDWORD_54_58){
		dwTmp = (DWORD*)pidentify->cur_capacity;
		printf("CHS: %dx%dx%d = %d\n",
			pidentify->cur_cyn,
			pidentify->cur_head,
			pidentify->cur_sector_track,
			*dwTmp );
	}else{
		printf("CHS: %dx%dx%d\n",
			pidentify->cyn,
			pidentify->head,
			pidentify->sector_track );
	}

	// LBA type
	dwTmp = (DWORD*)pidentify->total_sector;
	printf("LBA: %d\n", *dwTmp );

	ullSize = *dwTmp;
	ullSize <<= 9; // 2^9 = 512
	ddSize = (double)(*dwTmp >> 11) / (double)1024;

	// size
	printf( "total: %.1f GB (%I64d bytes)\n",
		ddSize,
		ullSize );

	// Buffer size
	if( pidentify->_buffer_size512 ){
		printf( "Buffer size : %dKB\n", (pidentify->_buffer_size512)>>1 );
	}

	printf("---\n");
	// Ultra DMA
	printf("Ultra DMA mode supported: ");
	if( (pidentify->word_valid & WORD53_VALIDWORD_88) &&
		(pidentify->udma_support & WORD88_UDMA_SUPPORTED) ){
		if( pidentify->udma_support & WORD88_UDMA0 ){
			printf("0");
		}
		if( pidentify->udma_support & WORD88_UDMA1 ){
			printf("-1");
		}
		if( pidentify->udma_support & WORD88_UDMA2 ){
			printf("-2");
		}
		if( pidentify->udma_support & WORD88_UDMA3 ){
			printf("-3");
		}
		if( pidentify->udma_support & WORD88_UDMA4 ){
			printf("-4");
		}
		if( pidentify->udma_support & WORD88_UDMA5 ){
			printf("-5");
		}
		printf("\n");
	}else{
		printf("not supported\n");
	}

	// Multiword DMA
	printf("Multiword DMA mode supported: ");	
	if( pidentify->multi_dma & WORD63_MWDMA_SUPPORTED ){
		if( pidentify->multi_dma & WORD63_MWDMA0 ){
			printf("0");
		}
		if( pidentify->multi_dma & WORD63_MWDMA1 ){
			printf("-1");
		}
		if( pidentify->multi_dma & WORD63_MWDMA2 ){
			printf("-2");
		}
		printf("\n");
	}else{
		printf("not supported\n");
	}

	// Single DMA
	printf("Single DMA mode supported: ");

	if( pidentify->single_dma ){
		printf("supported?\n");
	}else{
		printf("not supported\n");
	}

	// Advanced PIO
	printf("Advanced PIO mode supported: ");
	if( pidentify->adv_pio & WORD64_PIO_SUPPORT ){
		if( pidentify->adv_pio & WORD64_PIO3 ){
			printf("3");
		}
		if( pidentify->adv_pio & WORD64_PIO4 ){
			printf("-4");
		}
		printf("\n");
	}else{
		printf("not supported\n");
	}
	// Default transfer mode
	printf("Default transfer mode : ");
	DispDefaultTransferMode(pidentify);
	printf("\n");
	// Is SMART Supported/Enabled
	printf("S.M.A.R.T. Supported/Enabled : ");
	if( IsSmartSupported(pidentify) ){
		printf("Yes/");
	}else{
		printf("No/");
	}
	if( IsSmartEnabled(pidentify) ){
		printf("Yes\n");
	}else{
		printf("No\n");
	}

	printf("---\n");

	// Major version
	if( pidentify->major_ver_number == 0 ||
		pidentify->major_ver_number == 0xFFFF ){
		printf("ATA Major version: not supported\n");
	}else{
		bMinus = FALSE;
		printf("ATA Major version: ");
		for( i=2; i<13; i++ ){
			if( pidentify->major_ver_number & (1<<i) ){
				if( bMinus ){
					printf("-");
				}else{
					bMinus = TRUE;
				}
				printf("%d",i);
			}
		}
		printf("\n");
	}

	// Minor version
	if( pidentify->minor_ver_number == 0 ||
		pidentify->minor_ver_number == 0xFFFF ){
		printf("ATA Minor version: not supported\n");
	}else{
		printf("ATA Minor version: %s\n",
			minor_version[pidentify->minor_ver_number] );
	}

	// end...
	printf("---\n");
	printf("\n");
	return;
}


VOID
DispSmartIdentifyDump(
	PATA_INDENTIFYDATA pidentify
	)
{
	PWORD pw;
	int   i;

	printf("ATA Identify raw dump :\n");

	printf("   |    0    1    2    3    4    5    6    7\n");
    printf("---+----------------------------------------\n");
	printf("  0| ");

	pw = (PWORD)pidentify;
	for( i=0; i<(sizeof(ATA_INDENTIFYDATA)/sizeof(WORD)); i++ ){
		printf( "%04x", *(pw+i) );
		if( (i+1)%8 ){
			printf(" ");
		}else{
			if( i< (sizeof(ATA_INDENTIFYDATA)/sizeof(WORD))-1 ){
				printf("\n%3d| ",i+1);
			}else{
				printf("\n");
			}
		}
	}

	printf("\n\n");

	return;
}


VOID
DispSmartByteDump(
	PBYTE pb,
	INT   cbSize
	)
{
	INT i;

	printf("   | +0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +A +B +C +D +E +F\n");
    printf("---+------------------------------------------------\n");
	printf(" 00| ");
	for( i=0; i<cbSize; i++ ){
		printf( "%02x", *(pb+i) );
		if( (i+1)%16 ){
			printf(" ");
		}else{
			if( i<cbSize-1 ){
				printf("\n%3X| ", i+1 );
			}else{
				printf("\n");
			}
		}
	}

	printf("\n\n");

	return;
}


VOID
DispDefaultTransferMode(
	PATA_INDENTIFYDATA pidentify
	)
{
	if( (pidentify->word_valid & WORD53_VALIDWORD_88) &&
		(pidentify->udma_support & WORD88_UDMA_SELECTED) ){
		printf("Ultra DMA mode " );
		if( pidentify->udma_support & WORD88_UDMA0_SELECT ){
			printf("0");
		}
		if( pidentify->udma_support & WORD88_UDMA1_SELECT ){
			printf("1");
		}
		if( pidentify->udma_support & WORD88_UDMA2_SELECT ){
			printf("2");
		}
		if( pidentify->udma_support & WORD88_UDMA3_SELECT ){
			printf("3");
		}
		if( pidentify->udma_support & WORD88_UDMA4_SELECT ){
			printf("4");
		}
		if( pidentify->udma_support & WORD88_UDMA5_SELECT ){
			printf("5");
		}
	}else if( pidentify->multi_dma & WORD63_MWDMA_SELECTED ){
		printf("Multiword DMA mode ");
		if( pidentify->multi_dma & WORD63_MWDMA0_SELECT ){
			printf("0");
		}
		if( pidentify->multi_dma & WORD63_MWDMA1_SELECT ){
			printf("1");
		}
		if( pidentify->multi_dma & WORD63_MWDMA2_SELECT ){
			printf("2");
		}
	}else{
		printf("PIO mode, maybe...");
	}

	return;
}


VOID
DispSmartDeviceAttribute(
	PATA_ATTRIBUTEDATA	pattrib,
	PATA_THRESHOLDSDATA	pthresholds
	)
{
	int i;

	printf("SMART Device Attribute list\n");
	printf(" ID| ATTR - THRE (status)\n");
	printf("---+---------------------\n");
	for( i=0; i<30; i++ ){
		if( (pattrib->dev_attr[i].attr_id) == 0 ){
			break;
		}
		printf("%3d| %4d - %4d (%02X)\n",
			pattrib->dev_attr[i].attr_id,
			pattrib->dev_attr[i].value,
			pthresholds->dev_thre[i].thresholds,
			pattrib->dev_attr[i].status );
	}

	printf("\n");
	return;
}


BOOL
DispFindATADisk(
	BYTE num,
	INT  iLevel
	)
{
	HANDLE	hSmart;
	BYTE	bDeviceNum;
	DWORD	dwErr;
	BOOL	bFound, bRet, bAttr, bThr;
	GETVERSIONINPARAMS getver;
	SMART_ATA_IDENTIFY identify;
	SMART_READ_ATTRIBUTE_VALUE attrib;
	SMART_READ_THRESHOLDS thresholds;
	PATA_INDENTIFYDATA pident;

	BYTE	i, max_number;

	bFound = FALSE;
	bAttr  = FALSE;
	bThr   = FALSE;

	if( IS_NT ){
		max_number = ATA_WINNT_MAX_DRIVENUMBER;
	}else{
		max_number = ATA_WIN9X_MAX_DRIVENUMBER;
	}

	if( num != ENUM_ALLDRIVE ){
		max_number = 1;
	}

	for( i=0; i<max_number; i++ ){
		if( num == ENUM_ALLDRIVE ){
			hSmart = SmartGetHandle( i, &bDeviceNum, &getver );
		}else{
			hSmart = SmartGetHandle( num, &bDeviceNum, &getver );
		}

		if( hSmart == INVALID_HANDLE_VALUE ){
			dwErr = GetLastError();
			if( dwErr == ERROR_FILE_NOT_FOUND ){
				break;
			}
#if 0
			if( dwErr == ERROR_ACCESS_DENIED || 
				dwErr == ERROR_NOT_ENOUGH_MEMORY ||
				dwErr == ERROR_INVALID_FUNCTION ){
				DispError(dwErr, iLevel);
				break;
			}
#endif
			continue;
		}

		// get ATA identify
		bRet = SmartATAIdentify( hSmart, bDeviceNum, &identify );
		pident = (PATA_INDENTIFYDATA)identify.bBuffer;

		// Debug only
		if( bRet &&	(iLevel==DISPLEVEL_DEBUG) && IsSmartSupported(pident) ){
			if( !SmartATAReturnStatus(hSmart, bDeviceNum) ){
				SmartATAEnableDisableOperation( hSmart, bDeviceNum, TRUE );
				SmartATAEnableDisableAutosave( hSmart, bDeviceNum, TRUE );
			}
			bAttr = SmartATAReadAttributeValue( hSmart, bDeviceNum, &attrib );
			if( bAttr ){
				bThr  = SmartATAReadAttributeThresholds( hSmart, bDeviceNum, &thresholds );
			}
		}

		CloseHandle(hSmart);

		if( !bRet ){
			continue;
		}

		// Disp!
		bFound = TRUE;
		if( iLevel == DISPLEVEL_SUMMARY ){
			if( num == ENUM_ALLDRIVE ){
				printf( "ATADisk[%d]: ", i );
			}else{
				printf( "ATADisk[%d]: ", num );
			}
		}else if( iLevel != DISPLEVEL_NONE ){
			if( num == ENUM_ALLDRIVE ){
				printf("\n---------- ATADisk[%d]", i);
			}else{
				printf("\n---------- ATADisk[%d]", num);
			}
			printf("(%s) ----------\n", (bDeviceNum&1)?"slave":"master");
		}
		
		// disp smart version
		DispSmartVersion( &getver, iLevel );
		// disp ata identify information
		DispSmartIdentify( pident, iLevel );

		// debug only disp!
		if( iLevel == DISPLEVEL_DEBUG && num == ENUM_ALLDRIVE ){
			if( bAttr ){
				DispSmartReadAttribute( (PATA_ATTRIBUTEDATA)attrib.bBuffer, iLevel );
			}
			if( bThr ){
				DispSmartReadThresholds( (PATA_THRESHOLDSDATA)thresholds.bBuffer, iLevel );
			}
			if( bAttr && bThr ){
				DispSmartDeviceAttribute(
					(PATA_ATTRIBUTEDATA)attrib.bBuffer,
					(PATA_THRESHOLDSDATA)thresholds.bBuffer );
			}
		}

		continue;
	}

	if( !bFound && (iLevel!=DISPLEVEL_NONE) ){
		printf("ATADisk is not found from your system...\n");
	}

	return bFound;
}


VOID
DispError(
	DWORD dwErrNo,
	INT  iLevel
	)
{
	DWORD dwRet;
    PVOID lpBuffer;

	if( iLevel == DISPLEVEL_NONE ){
		return;
	}

	dwRet = FormatMessage(
				FORMAT_MESSAGE_ALLOCATE_BUFFER |
				FORMAT_MESSAGE_FROM_SYSTEM,
				NULL,
				dwErrNo,  
				MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
				(LPTSTR)&lpBuffer,  
				0,  
				NULL
				);

	if( dwRet == 0 ){
		printf( "Error No.[%d]\nError FormatMessage()[%d]\n", dwErrNo, GetLastError() );
	}else{
		printf( "Error No.[%d]\n%s\n", dwErrNo, lpBuffer );
	}

	if( lpBuffer != NULL ){
		LocalFree( lpBuffer );
	}

	return;
}


#endif // _CONSOLE
