/* identify.c - ATA identify functions
 *
 * Copyright (c) 1998-2000 Mc.N(Makoto NARA)
 * For conditions of distribution and use, see copyright notice in smart2k.h 
 *
 */

#include "smart2k.h"

/* F-U-N-C-T-I-O-N */


BOOL
SmartATAIdentify(
	IN  HANDLE hDevice,					/* Target IDE handle */
	IN  BYTE bDeviceNum,				/* */
	OUT PSMART_ATA_IDENTIFY pidentify	/* */
	)
{
	BOOL   bRet;
	DWORD  cbReturn;
	SENDCMDINPARAMS sendparamIN;

	/* zero clear */
	ZeroMemory( &sendparamIN, sizeof(SENDCMDINPARAMS)    );
	ZeroMemory( pidentify,    sizeof(SMART_ATA_IDENTIFY) );

	/* set param */
	sendparamIN.irDriveRegs.bFeaturesReg = 0;
	sendparamIN.irDriveRegs.bSectorCountReg = 1;
	sendparamIN.irDriveRegs.bSectorNumberReg = 1;
	sendparamIN.irDriveRegs.bCylLowReg = 0;
	sendparamIN.irDriveRegs.bCylHighReg = 0;

	sendparamIN.irDriveRegs.bDriveHeadReg = ((bDeviceNum & 1)<<4)|0xA0;
	sendparamIN.irDriveRegs.bCommandReg   = ID_CMD;
	sendparamIN.bDriveNumber              = bDeviceNum;
	sendparamIN.cBufferSize				  = IDENTIFY_BUFFER_SIZE;

	/* send command */
	bRet = DeviceIoControl(
				hDevice, SMART_RCV_DRIVE_DATA,
				&sendparamIN, sizeof(SENDCMDINPARAMS) - 1,
				pidentify,    sizeof(SMART_ATA_IDENTIFY),
				&cbReturn,	  NULL
	);

	return bRet;
}


BOOL
IsSmartEnabled(
	PATA_INDENTIFYDATA pidentify
	)
{
	// SMART is supported?
	if( !IsSmartSupported(pidentify) ){
		return FALSE;
	}
	if( (pidentify->command_set_def & WORD87_SHALLBE_MASK) != WORD87_SHALLBE_SET ){
		// word 85-87 is not supported
		return FALSE;
	}
	if( pidentify->command_set_en1 & WORD85_ENABLED_SMART ){
		return TRUE;
	}
	return FALSE;
}


BOOL
IsSmartSupported(
	PATA_INDENTIFYDATA pidentify
	)
{
	if( (pidentify->command_sets & WORD83_SHALLBE_MASK) != WORD83_SHALLBE_SET ){
		// word 82-83 is not supported
		return FALSE;
	}
	if( pidentify->command_set & WORD82_SUPPORT_SMART ){
		return TRUE;
	}
	return FALSE;
}

