/* smart2k.c - generic purpose functions for console
 *
 * Copyright (c) 1998-2000 Mc.N(Makoto NARA)
 * For conditions of distribution and use, see copyright notice in smart2k.h 
 *
 */

#include "smart2k.h"

#define RUN_NONE	0
#define RUN_HELP	1
#define RUN_DEBUG	2
// #define RUN_ENUM	3
#define RUN_INFO	4
#define RUN_STATUS	5
#define RUN_ENABLE	6
#define RUN_DISABLE	7


/* P-R-O-T-O-T-Y-P-E */
VOID usage(VOID);


/* F-U-N-C-T-I-O-N */


/* M A I N */



int
main(
	int argc,
	char *argv[]
	)
{
	int i, iRet;
	int run, disp;
	BYTE num;
	BOOL bRet;

//	iRet = 0;
	num  = ENUM_ALLDRIVE;		// all drive
	run  = RUN_NONE;			// no run
	disp = DISPLEVEL_SUMMARY;	// summary

	if( argc < 2 ){
		usage();
		return 0;
	}

	for(i=1; i<argc; i++){
		if( 0 == lstrcmpi(argv[i],"-help") ){
			run = RUN_HELP;
			break;
		}
		if( 0 == lstrcmpi(argv[i],"-debug") ){
			run = RUN_DEBUG;
			break;
		}
		if( 0 == lstrcmpi(argv[i],"-nodisp") ){
			disp = DISPLEVEL_NONE;
			continue;
		}
		if( 0 == lstrcmpi(argv[i],"-detail") ){
			disp = DISPLEVEL_DETAIL;
			continue;
		}
		if( 0 == lstrcmpi(argv[i],"-summary") ){
			disp = DISPLEVEL_SUMMARY;
			continue;
		}
		if( 0 == lstrcmpi(argv[i],"-info") ){
			run = RUN_INFO;
			continue;
		}
		if( 0 == lstrcmpi(argv[i],"-status") ){
			run = RUN_STATUS;
			continue;
		}
		if( 0 == lstrcmpi(argv[i],"-enable") ){
			run = RUN_ENABLE;
			continue;
		}
		if( 0 == lstrcmpi(argv[i],"-disable") ){
			run = RUN_DISABLE;
			continue;
		}
		if( (argv[i][0] == '-') &&
			(argv[i][1] == 'a' || argv[i][1] == 'A') &&
			(argv[i][2] == 't' || argv[i][1] == 'T') &&
			(argv[i][3] == 'a' || argv[i][1] == 'A') &&
			(argv[i][4] != '\0') ){
			num = atoi(&argv[i][4]);
			if( run == RUN_NONE ){
				run = RUN_INFO;
			}
			continue;
		}

		printf("WARNING : non-argument[%s]\n", argv[i] );
	}

	switch(run){
	case RUN_NONE:
	case RUN_HELP:
		usage();
		break;
	case RUN_DEBUG:
		bRet = DispFindATADisk( ENUM_ALLDRIVE, DISPLEVEL_DEBUG );
		break;
	case RUN_INFO:
		bRet = DispFindATADisk( num, disp );
		break;
	case RUN_STATUS:
		bRet = DispSmartReturnStatus( num, disp );
		break;
	case RUN_ENABLE:
		bRet = DispSmartEnableDisableOperation( num, TRUE, disp );
		break;
	case RUN_DISABLE:
		bRet = DispSmartEnableDisableOperation( num, FALSE, disp );
		break;
	default:
		usage();
		break;
	}

	if( bRet ){
		iRet = 0;	// TRUE
	}else{
		iRet = 1;	// FALSE
	}

	return iRet;
}



VOID
usage()
{
	printf("\n");
	printf("S.M.A.R.T. utility for Windows 95/98/NT/2000 ver.%s\n", SMART2K_VER_STRING);
	printf("%s\n\n", COPYRIGHT_INFO_STRING);
	printf("Usage:\n");
	printf("  -help   : This message.\n");
	printf("  -info   : Information harddisk\n");
	printf("Drive parameter\n");
	printf("  -ata[x] : Select ATA drive (ex. -ata0 is setting ATA drive0)\n");
	printf("SMART parameter\n");
	printf("  -status : Call SMART RETURN STATUS function.\n");
	printf("  -enable : Call SMART ENABLE OPERATIONS function\n");
	printf("Display parameter\n");
	printf("  -nodisp : non display.\n");
	printf("  -detail : detail display.\n");
	printf("  -summary: summary display(default).\n");
	printf("\n");

//	printf("-debug  : debug information\n");
//	printf("-disable: Call SMART DISABLE OPERATIONS function\n");

	return;
}


#if 0
int main(void)
{
	HANDLE	hSmart;
	BOOL	bRet;
	INT		iLevel;

	GETVERSIONINPARAMS getver;
	SMART_ATA_IDENTIFY identify;
	PATA_INDENTIFYDATA	pata_ident;

// DISPLEVEL_DEBUG
// win9x
//	BYTE	bDeviceNum = ATA_PRIMARY_MASTER;
// winnt

	BYTE bPhysical;
	BYTE bDeviceNum;

	iLevel = DISPLEVEL_NONE;
	bPhysical = 0;
	bDeviceNum = 0;

	/* get handle */
	hSmart = SmartGetHandle( bPhysical, &bDeviceNum, &getver );
	if( hSmart == INVALID_HANDLE_VALUE ){
		printf( "Error SmartGetHandle [%d]\n", GetLastError() );

		DEBUGMSG(("Can't open smart handle!\n"));
		return -1;
	}

	DispSmartVersion( &getver, iLevel );

	/* get identify */
	bRet = SmartATAIdentify( hSmart, bDeviceNum, &identify );
	if( !bRet ){
		DEBUGMSG(("Can't get Identify!\n"));
		CloseHandle( hSmart );
		hSmart = INVALID_HANDLE_VALUE;
		return -2;
	}

	pata_ident = (PATA_INDENTIFYDATA)identify.bBuffer;
	DispSmartIdentify( pata_ident, iLevel );

#if 0
	if( IsSmartSupported(pata_ident) ){
		printf("SMART is supported\n");
	}
	if( IsSmartEnabled(pata_ident) ){
		printf("SMART is enabled\n");
	}
#endif
	SmartATAEnableDisableOperation(hSmart, bDeviceNum, TRUE );
	SmartATAReturnStatus( hSmart, bDeviceNum );

// IOCTL_DISK_CONTROLLER_NUMBER
// IOCTL_STORAGE_GET_MEDIA_TYPES_EX

//	SmartATAReadAttributeValue( hSmart, bDeviceNum, &smart_attrib );
//	SmartATAReadAttributeThresholds( hSmart, bDeviceNum, &smart_thresholds );

	SmartATASaveAttributeValue(hSmart, bDeviceNum);
	SmartATAOfflineImmediate(hSmart, bDeviceNum, 1);

	CloseHandle( hSmart );



	return 0;
}

#endif


#if 0
int main()
{
	HANDLE hSmart;
	BOOL	bRet;
	GETVERSIONINPARAMS getver;


	hSmart = CreateFile( "\\\\.\\C:",
					   GENERIC_READ | GENERIC_WRITE,
					   FILE_SHARE_READ|FILE_SHARE_WRITE,
					   NULL,
					   OPEN_EXISTING,
					   0,
					   NULL );

	if( hSmart == INVALID_HANDLE_VALUE ){
		return -1;
	}

	bRet = SmartGetVersion( hSmart, &getver );
	if( !bRet ){
		CloseHandle(hSmart);
		return -2;
	}

	CloseHandle(hSmart);

	return 0;
}

#endif
