/* smart2k.h - header file for smart2k program
 *
 * Copyright (c) 1998-2000 Mc.N(Makoto NARA)
 */

/*
 * COPYRIGHT NOTICE:
 *
 * Copyright (c) 1998-2000 Mc.N(Makoto NARA) All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */



/* I-N-C-L-U-D-E */

#define STRICT
#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0400
#endif
#include <windows.h>
#include <winioctl.h>
#ifdef _CONSOLE
#include <stdio.h>
#endif // _CONSOLE

// #ifndef _WIN32_WINNT
// #include "smart9x.h"
// #endif // _WIN32_WINNT


#ifndef _STRAGE_SMART_H
#define _STRAGE_SMART_H

#pragma pack(push,1)

/* D-E-F-I-N-E */
/* Copyrigth information*/
#define COPYRIGHT_INFO_STRING "Copyright (c) 1998-2000 Mc.N(Makoto NARA) All rights reserved."

/* Version information */
#define SMART2K_VER_STRING	"0.1.1"
/* xxyyzz, where x=major, y=minor, z=bugfix */
#define SMART2K_VER			101		/* 0.1.1 */


// Windows NT MAX physical drive
#define ATA_WINNT_MAX_DRIVENUMBER	25	// tekitou
#define	ATA_WIN9X_MAX_DRIVENUMBER	4

#define ENUM_ALLDRIVE 255

// Windows 9x physical drive name.
#define ATA_PRIMARY_MASTER   0
#define ATA_PRIMARY_SLAVE    1
#define ATA_SECONDARY_MASTER 2
#define ATA_SECONDARY_SLAVE  3

// display level
#define DISPLEVEL_NONE		0
#define DISPLEVEL_DEBUG		1
#define DISPLEVEL_SUMMARY	2
#define DISPLEVEL_DETAIL	3
// #define 

#if 0
// SMART Feature register values
// not used...
#define SMART_READ_ATTRIBUTE_VALUES				0xD0	// ATA-3, 
#define SMART_READ_DATA							0xD0	// renamed ATA-4
#define SMART_READ_ATTRIBUTE_THRESHOLDS			0xD1	// ATA-3, obsoleted ATA-4
#define SMART_ENABLE_DISABLE_ATTRIBUTE_AUTOSAVE	0xD2	// ATA-3
#define SMART_SAVE_ATTRIBUTE_VALUES				0xD3	// ATA-3
#define SMART_EXECUTE_OFFLINE_IMMEDIATE			0xD4	// ATA-4
#define SMART_READ_LOG							0xD5	// ATA-5 Windows NT is not supported, maybe.
#define SMART_WRITE_LOG							0xD6	// ATA-5 Windows NT is not supported, maybe.
#define SMART_ENABLE_OPERATIONS					0xD8	// ATA-3
#define SMART_DISABLE_OPERATIONS				0xD9	// ATA-3
#define SMART_RETURN_STATUS						0xDA	// ATA-3
#endif

// SMART EXECUTE OFF-LINE IMMEDIATE subcommand...
// see ATA-5 spec.
#define SMART_EXECUTE_OFFLINE_OFFLINE			0	// Execute SMART off-line routine immediately in off-line mode
#define SMART_EXECUTE_OFFLINE_SELFTEST			1	// Execute SMART Short self-test routine immediately in off-line mode
#define SMART_EXECUTE_OFFLINE_SELFTEST_EX		2	// Execute SMART Extended self-test routine immediately in off-line mode
#define SMART_EXECUTE_OFFLINE_SELFTEST_ABORT	127	// Abort off-line mode self-test routine
#define SMART_EXECUTE_OFFLINE_SELFTEST_CAP		129	// Execute SMART Short self-test routine immediately in captive mode
#define SMART_EXECUTE_OFFLINE_SELFTEST_CAP_EX	130	// Execute SMART Extended self-test routine immediately in captive mode


/* S-T-R-U-C-T */
// ATA IDENTIFY
typedef struct tagSMART_ATA_IDENTIFY{
	OUT DWORD			cBufferSize;
	OUT DRIVERSTATUS	DriverStatus;
	OUT BYTE			bBuffer[IDENTIFY_BUFFER_SIZE];
} SMART_ATA_IDENTIFY, *PSMART_ATA_IDENTIFY, *LPSMART_ATA_IDENTIFY;

// SMART RETURN STATUS
typedef struct tagSMART_RETURNSTATUS {
	OUT DWORD			cBufferSize;
	OUT DRIVERSTATUS	DriverStatus;
	OUT IDEREGS			irDriveRegs;
} SMART_RETURNSTATUS, *PSMART_RETURNSTATUS, *LPSMART_RETURNSTATUS;

// SMART READ ATTRIBUTE VALUE
typedef struct tagSMART_READ_ATTRIBUTE_VALUE{
	OUT DWORD			cBufferSize;
	OUT DRIVERSTATUS	DriverStatus;
	OUT BYTE			bBuffer[READ_ATTRIBUTE_BUFFER_SIZE];
} SMART_READ_ATTRIBUTE_VALUE, *PSMART_READ_ATTRIBUTE_VALUE;

typedef struct tagSMART_READ_THRESHOLDS{
	OUT DWORD			cBufferSize;
	OUT DRIVERSTATUS	DriverStatus;
	OUT BYTE			bBuffer[READ_THRESHOLD_BUFFER_SIZE];
} SMART_READ_THRESHOLDS, *PSMART_READ_THRESHOLDS;

//
// IDENTIFY DATA
//
typedef struct tagATA_INDENTIFYDATA{
	WORD	general_config;		/* [00] General configuration bit-significant information				*/
	WORD	cyn;				/* [01] Number of cylinders												*/
	WORD	specific_config;	/* [02] (ATA-5) Specific configuration 									*/
	WORD	head;				/* [03] Number of heads													*/
	WORD	_unfmt_track;		/* [04] Number of unformatted bytes per track							*/
								/*		(ATA-2) obsolete												*/
								/*		(ATA-4) retired													*/
	WORD	_unfmt_sector;		/* [05] Number of unformatted bytes per sector							*/
								/*      (ATA-2) obsolete												*/
								/*      (ATA-4) retired													*/
	WORD	sector_track;		/* [06] Number of sectors per track										*/
	WORD	_vendor_unique[3];	/* [07-09] Vendor unique												*/
								/*      (ATA-4) retired													*/
								/*      (ATA-5) [7-8] reserved for CompactFlash							*/
								/*              [9]   retired											*/
	WORD	serial_number[10];	/* [10-19] Serial number												*/
	WORD	_buffer_type;		/* [20] Buffer type														*/
								/*      (ATA-2) obsolete												*/
								/*      (ATA-4) retired													*/
	WORD	_buffer_size512;	/* [21] Buffer size in 512 byte increments								*/
								/*      (ATA-2) obsolete												*/
								/*      (ATA-4) retired													*/
	WORD	vendor_cmd;			/* [22] # of ECC bytes avail on read/write long cmds					*/
								/*      (ATA-4) obsolete												*/
	WORD	firmware[4];		/* [23-26] Firmware revision											*/
	WORD	model_number[20];	/* [27-46] Model number													*/
	WORD	intrRWmulti;		/* [47] Number of Sector/Interrupt R/W Multiples						*/
	WORD	dword_io;			/* [48] Doubleword I/O Support(Support = 1, No Support = 0)				*/
								/*      (ATA-2) Reserved												*/
	WORD	capability;			/* [49] IORDY/LBA/DMA Support											*/
								/*		15-10  0=reserved     15-12  0=reserved							*/
								/*		   11  If set, means Flow Control Supported.					*/
								/*		   10  If set, means Flow Control can be disabled.				*/
								/*			9  1=LBA supported											*/
								/*			8  1=DMA supported											*/
								/*		 7- 0  Vendor unique											*/
	WORD	capability2;		/* [50] (ATA-4) Capacities												*/
	WORD	timing_pio;			/* [51] PIO data transfer cycle timing mode								*/
								/*      (ATA-5) Obsolete												*/
	WORD	timing_dma;			/* [52] DMA data transfer cycle timing mode								*/
								/*      (ATA-4) retired													*/
								/*      (ATA-5) Obsolete												*/
	WORD	word_valid;			/* [53] Addional Words Valid											*/
	WORD	cur_cyn;			/* [54] Number of current cylinders										*/
	WORD	cur_head;			/* [55] Number of current heads											*/
	WORD	cur_sector_track;	/* [56] Number of current sectors per track								*/
	WORD	cur_capacity[2];	/* [57-58] Current capacity in sectors									*/
	WORD	cur_block;			/* [59] Current Blocking Factor											*/
	WORD	total_sector[2];	/* [60-61] Total number of user addressable sectors (LBA mode only)		*/
	WORD	single_dma;			/* [62] Single Word DMA transfer mode Supported							*/
								/*      (ATA-3) Obsolete												*/
								/*      (ATA-4) retired													*/
								/*      (ATA-5) Obsolete												*/
	WORD	multi_dma;			/* [63] Multi-Word DMA transfer mode Supported							*/
	WORD	adv_pio;			/* [64] (ATA-2) Advanced PIO mode Supported								*/
	WORD	min_time_multi_dma;	/* [65] (ATA-2) Minimum Multi-DMA Trancfer Cycle Time(ns)				*/
	WORD	man_time_multi_dma;	/* [66] (ATA-2) Manufacturer Recommended Multi-DMA Cycle Time			*/
	WORD	min_wo_pio3;		/* [67] (ATA-2) Minimum PIO Transfer Cycle Time without Mode 3 PIO		*/
	WORD	min_w_pio3;			/* [68] (ATA-2) Minimum PIO Transfer Cycle Time with Mode 3 PIO			*/
	WORD	future_reserved[6];	/* [69-74] (ATA-3) Reserved (for future command overlap and queuing)	*/
	WORD	queue_depth;		/* [75] (ATA-4) Queue depth												*/
	WORD	_reserved1[4];		/* [76-79] Reserved														*/
	WORD	major_ver_number;	/* [80] (ATA-3) Major version number									*/
	WORD	minor_ver_number;	/* [81] (ATA-3) Minor version number									*/
	WORD	command_set;		/* [82] (ATA-3) Command set supported									*/
	WORD	command_sets;		/* [83] (ATA-3) Command sets supported									*/
	WORD	command_set_ext;	/* [84] (ATA-4) Command set/feature supported extension					*/
	WORD	command_set_en1;	/* [85] (ATA-4) Commnad set/feature enabled								*/
	WORD	command_set_en2;	/* [86] (ATA-4) Commnad set/feature enabled								*/
	WORD	command_set_def;	/* [87] (ATA-4) Commnad set/feature default								*/
	WORD	udma_support;		/* [88] (ATA-4) UDMA support and select flag							*/
	WORD	for_security89;		/* [89] (ATA-4) Time required security erase unit completion			*/
	WORD	for_eh_security90;	/* [90] (ATA-4) Time required Enhanced security erase unit completion 	*/
	WORD	adv_power;			/* [91] (ATA-4) Current advenced power management value					*/
	WORD	master_password;	/* [92] (ATA-5) Master Password Revision Code							*/
	WORD	hardware_reset;		/* [93] (ATA-5) Hardware reset result									*/
	WORD	_reserved2[33];		/* [94-126] Reserved													*/
	WORD	removable_status;	/* [127] (ATA-4) Removable Media Status Notification feature set support */
	WORD	security_status;	/* [128] (ATA-3) Security status										*/
	WORD	vendor_specific[31];/* [129-159] Vendor specific											*/
	WORD	cfa_power1;			/* [160]     (ATA-5) CFA power mode 1									*/
	WORD	_rsv_compact[15];	/* [161-175] (ATA-5) Reserved for assignment by CompactFlash Association */
	WORD	_reserved3[79];		/* [176-254] reserved													*/
	WORD	integrity_word;		/* [255] (ATA-5) Integrity word											*/
} ATA_INDENTIFYDATA, *PATA_INDENTIFYDATA, *LPATA_INDENTIFYDATA;

// [53] Addional Words Valid
#define WORD53_VALIDWORD_88		(1<<2)
#define WORD53_VALIDWORD_64_70	(1<<1)
#define WORD53_VALIDWORD_54_58	(1<<0)


// [63] Multi-Word DMA transfer mode Supported
#define WORD63_MWDMA2_SELECT	(1<<10)
#define WORD63_MWDMA1_SELECT	(1<<9)
#define WORD63_MWDMA0_SELECT	(1<<8)
#define WORD63_MWDMA_SELECTED	(WORD63_MWDMA0_SELECT | WORD63_MWDMA1_SELECT | WORD63_MWDMA2_SELECT)
#define WORD63_MWDMA2			(1<<2)
#define WORD63_MWDMA1			(1<<1)
#define WORD63_MWDMA0			(1<<0)
#define WORD63_MWDMA_SUPPORTED	(WORD63_MWDMA0 | WORD63_MWDMA1 | WORD63_MWDMA2)

// [64] Advanced PIO mode Supported	
#define WORD64_PIO4				(1<<1)
#define WORD64_PIO3				(1<<0)
#define WORD64_PIO_SUPPORT		(WORD64_PIO4 | WORD64_PIO3)

// [80] (ATA-3) Major version number
#define WORD80_ATA14			(1<<14)	// reserved
#define WORD80_ATA13			(1<<13)	// reserved
#define WORD80_ATA12			(1<<12)	// reserved
#define WORD80_ATA11			(1<<11)	// reserved
#define WORD80_ATA10			(1<<10)	// reserved
#define WORD80_ATA9				(1<<9)	// reserved
#define WORD80_ATA8				(1<<8)	// reserved
#define WORD80_ATA7				(1<<7)	// reserved
#define WORD80_ATA6				(1<<6)
#define WORD80_ATA5				(1<<5)
#define WORD80_ATA4				(1<<4)
#define WORD80_ATA3				(1<<3)
#define WORD80_ATA2				(1<<2)

// [81] (ATA-3) Minor version number

// [82] Command set supported
#define WORD82_SUPPORT_NOP		(1<<14)
#define WORD82_SUPPORT_RBUFFER	(1<<13)
#define WORD82_SUPPORT_WBUFFER	(1<<12)
#define WORD82_SUPPORT_PROTECT	(1<<10)
#define WORD82_SUPPORT_DRESET	(1<<9)
#define WORD82_SUPPORT_SERVICE	(1<<8)
#define WORD82_SUPPORT_RIRPT	(1<<7)
#define WORD82_SUPPORT_LAHEAD	(1<<6)
#define WORD82_SUPPORT_WCACHE	(1<<5)
#define WORD82_SUPPORT_PM		(1<<3)
#define WORD82_SUPPORT_REMOVE	(1<<2)
#define WORD82_SUPPORT_SECURITY	(1<<1)
#define WORD82_SUPPORT_SMART	(1<<0)

// [83] (ATA-3) Command sets supported
#define WORD83_SHALLBE_CLEAR	(1<<15)
#define WORD83_SHALLBE_SET		(1<<14)
#define WORD83_SHALLBE_MASK		(WORD83_SHALLBE_CLEAR | WORD83_SHALLBE_SET)

// [85] (ATA-4) Commnad set/feature enabled
#define WORD85_ENABLED_SMART	(1<<0)

// [87] (ATA-4) Commnad set/feature default
#define WORD87_SHALLBE_CLEAR	(1<<15)
#define WORD87_SHALLBE_SET		(1<<14)
#define WORD87_SHALLBE_MASK		(WORD87_SHALLBE_CLEAR | WORD87_SHALLBE_SET)

// [88] Ultra DMA
#define WORD88_UDMA5_SELECT		(1<<13)		// ATA-6
#define WORD88_UDMA4_SELECT		(1<<12)
#define WORD88_UDMA3_SELECT		(1<<11)
#define WORD88_UDMA2_SELECT		(1<<10)
#define WORD88_UDMA1_SELECT		(1<<9)
#define WORD88_UDMA0_SELECT		(1<<8)
#define WORD88_UDMA_SELECTED	(WORD88_UDMA0_SELECT | WORD88_UDMA1_SELECT | WORD88_UDMA2_SELECT |\
								 WORD88_UDMA3_SELECT | WORD88_UDMA4_SELECT | WORD88_UDMA5_SELECT)
#define WORD88_UDMA5			(1<<5)		// ATA-6
#define WORD88_UDMA4			(1<<4)
#define WORD88_UDMA3			(1<<3)
#define WORD88_UDMA2			(1<<2)
#define WORD88_UDMA1			(1<<1)
#define WORD88_UDMA0			(1<<0)
#define WORD88_UDMA_SUPPORTED	(WORD88_UDMA0 | WORD88_UDMA1| WORD88_UDMA2 | WORD88_UDMA3 | WORD88_UDMA4 | WORD88_UDMA5)




//
// Attributes Data Structure
//
typedef struct tagATA_DEVICE_ATTRIBUTE{
	BYTE	attr_id;		// Attribute ID Number (01h to FFh)
	WORD	status;			// Status flags
	BYTE	value;			// Attribute Value (valid values from 01h to FDh)
	BYTE	vendor[8];		// Vendor Specific
} ATA_DEVICE_ATTRIBUTE, *PATA_DEVICE_ATTRIBUTE, DEV_ATTRIB;

typedef struct tagATA_ATTRIBUTEDATA{
	WORD		revision;			// Data Structure Revision Number
	DEV_ATTRIB	dev_attr[30];		// Device Attribute [1-30]
	BYTE		offline_stat;		// Offline data collection status
	BYTE		selftest_stat;		// Selftest execution status
	WORD		total_time;			// Total time in seconds to complete offline data collection activity
	BYTE		vendor;				// Vendor specific
	BYTE		offline_cap;		// Offline data collection capability
	WORD		smart_cap;			// SMART capability
	BYTE		err_cap;			// SMART device error logging capability
	BYTE		check_point;		// Selftest failure check point
	BYTE		selftest_time;		// Short selftest completion time in minutes
	BYTE		selftest_time_ex;	// Extended selftest completion time in minutes
	BYTE		reserved[12];		// Reserved
	BYTE		vendor2[125];		// Vendor specific
	BYTE		checksum;			// Data structure checksum
} ATA_ATTRIBUTEDATA, *PATA_ATTRIBUTEDATA;


//
// WARNING : This Attribute ID is Vendor specific. NOT USED!
// Deskstar 40GV & 75GXP hard disk drive specifications
// 

#define ATTRIB_ID_NOTUSED		0		// Indicates that this entry in the data structure is not used
#define ATTRIB_ID_RAW_READ		1		// Raw Read Error Rate
#define ATTRIB_ID_PARFORMANCE	2		// Throughput Performance
#define ATTRIB_ID_SPINUP_TIME	3		// Spin Up Time
#define ATTRIB_ID_START_STOP	4		// Start/Stop Count
#define ATTRIB_ID_REALLOC_SEC	5		// Reallocated Sector Count
#define ATTRIB_ID_SEEK_ERROR	7		// Seek Error Rate
#define ATTRIB_ID_SEEK_TIME		8		// Seek Time Performance
#define ATTRIB_ID_POWER_ON		9		// Power-on Hours Count
#define ATTRIB_ID_SPIN_RETRY	10		// Spin Retry Count
#define ATTRIB_ID_DEVICE_POWER	12		// Device Power Cycle Count
#define ATTRIB_ID_POWER_OFF		192		// Power-off Retract Count
#define ATTRIB_ID_LOAD_CYCLE	193		// Load Cycle Count
#define ATTRIB_ID_TEMPERATURE	194		// Temperature
#define ATTRIB_ID_REALLOC_EVENT	196		// Reallocation Event Count
#define ATTRIB_ID_PENDING_SEC	197		// Current Pending Sector Count
#define ATTRIB_ID_UNCORRECTABLE	198		// Off-line Scan Uncorrectable Sector Count
#define ATTRIB_ID_ULTRADMA_CRC	199		// Ultra DMA CRC Error Count


/*
 * Attributes Thresholds Data Structure
 */
typedef struct tagATA_DEVICE_THRESHOLDS{
	BYTE	attr_id;		// Attribute ID Number (01h to FFh)
	BYTE	thresholds;		// Attribute Threshold
	BYTE	reserved[10];	// Reserved (00h)
} ATA_DEVICE_THRESHOLDS, *PATA_DEVICE_THRESHOLDS, DEV_THRE;

typedef struct tagATA_THRESHOLDSDATA{
	WORD		revision;		// Data Structure Revision Number
	DEV_THRE	dev_thre[30];	// Device Attribute [1-30]
	BYTE		reserved[18];	// Reserved
	BYTE		vendor[131];	// Vendor specific
	BYTE		checksum;		// Data structure checksum
} ATA_THRESHOLDSDATA, *PATA_THRESHOLDSDATA;


#define IS_NT     (BOOL)(GetVersion() < 0x80000000)
#define IS_WIN32S (BOOL)(!(IS_NT) && (LOBYTE(LOWORD(GetVersion()))<4))
#define IS_WIN95  (BOOL)(!(IS_NT) && !(IS_WIN32S))

#ifdef _DEBUG
#define DEBUGMSG(msg){				\
	OutputDebugString("SMART: ");	\
	OutputDebugString (msg);		\
	}
#else
#define DEBUGMSG(msg)
#endif




/* P-R-O-T-O-T-Y-P-E */


/*
 *  identify.c
 */

BOOL
SmartATAIdentify(
	IN  HANDLE hDevice,
	IN  BYTE bDeviceNum,
	OUT PSMART_ATA_IDENTIFY pidentify
	);

BOOL
IsSmartSupported(
	PATA_INDENTIFYDATA pidentify
	);

BOOL
IsSmartEnabled(
	PATA_INDENTIFYDATA pidentify
	);


/*
 * smartcmd.c
 */

HANDLE
SmartGetHandle(
	IN	BYTE	bPhysical,
	OUT PBYTE	pbDeviceNum,
	OUT PGETVERSIONINPARAMS pgetver
	);

BOOL
SmartGetVersion(
	IN  HANDLE hDevice,
	OUT PGETVERSIONINPARAMS pgetverparams
	);

BOOL
SmartATAEnableDisableOperation(
	IN  HANDLE	hDevice,
	IN  BYTE	bDeviceNum,
	IN	BOOL	bOperation
	);

BOOL
SmartATAReturnStatus(
	IN  HANDLE	hDevice,
	IN  BYTE	bDeviceNum
	);

BOOL
SmartATAEnableDisableAutosave(
	IN  HANDLE	hDevice,
	IN  BYTE	bDeviceNum,
	IN	BOOL	bOperation
	);

BOOL
SmartATAReadAttributeValue(
	IN  HANDLE	hDevice,
	IN  BYTE	bDeviceNum,
	OUT PSMART_READ_ATTRIBUTE_VALUE pattrb_value
	);

BOOL
SmartATAReadAttributeThresholds(
	IN  HANDLE	hDevice,
	IN  BYTE	bDeviceNum,
	OUT PSMART_READ_THRESHOLDS pattrb_thresholds
	);

BOOL
SmartATAOfflineImmediate(
	IN  HANDLE	hDevice,
	IN  BYTE	bDeviceNum,
	IN	BYTE	bSubcommand
	);

BOOL
SmartATASaveAttributeValue(
	IN  HANDLE	hDevice,
	IN  BYTE	bDeviceNum
	);


/*
 * tools.c
 */

BOOL
word2str(
	IN  char  *master,
	IN  int   cb,
	OUT char  *target
	);


/*
 * disp.c
 */
#ifdef _CONSOLE

BOOL
DispSmartReturnStatus(
	BYTE num,
	INT  iLevel
	);

BOOL
DispSmartEnableDisableOperation(
	BYTE num,
	BOOL bOp,
	INT  iLevel
	);

VOID
DispSmartReadThresholds(
	PATA_THRESHOLDSDATA	pthresholds,
	INT					iLevel
	);

VOID
DispSmartReadAttribute(
	PATA_ATTRIBUTEDATA	pattrib,
	INT					iLevel
	);

VOID
DispSmartIdentify(
	PATA_INDENTIFYDATA	pidentify,
	INT					iLevel
	);

VOID
DispSmartVersion(
	PGETVERSIONINPARAMS pgetver,
	INT					iLevel
	);

BOOL
DispFindATADisk(
	BYTE num,
	INT  iLevel
	);

VOID
DispError(
	DWORD dwErrNo,
	INT  iLevel
	);

#endif // _CONSOLE


#pragma pack(pop)
#endif // _STRAGE_SMART_H


