/* smartcmd.c - ATA S.M.A.R.T. functions
 *
 * Copyright (c) 1998-2000 Mc.N(Makoto NARA)
 * For conditions of distribution and use, see copyright notice in smart2k.h 
 *
 */

#include "smart2k.h"


/* P-R-O-T-O-T-Y-P-E */

HANDLE
SmartGetHandle9x(
	IN	BYTE	bPhysical,
	OUT PBYTE	pbDeviceNum,
	OUT PGETVERSIONINPARAMS pgetver
	);

HANDLE
SmartGetHandleNT(
	IN	BYTE	bPhysical,
	OUT PBYTE	pbDeviceNum,
	OUT PGETVERSIONINPARAMS pgetver
	);

/* F-U-N-C-T-I-O-N */

/* Get S.M.A.R.T. handle.
 * bPhysical is each harddisk number. 
 * Win9x is 0-ATA_WIN9X_MAX_DRIVENUMBER,
 * WinNT is 0-ATA_WINNT_MAX_DRIVENUMBER
 * pbDeviceNum returned bIDEDeviceMap.
 */
HANDLE
SmartGetHandle(
	IN	BYTE	bPhysical,
	OUT PBYTE	pbDeviceNum,
	OUT PGETVERSIONINPARAMS pgetver
	)
{
	HANDLE hSmart;

	if( IS_NT ){
		hSmart = SmartGetHandleNT( bPhysical, pbDeviceNum, pgetver );
	}else{
		hSmart = SmartGetHandle9x( bPhysical, pbDeviceNum, pgetver );
	}

	return hSmart;
}


HANDLE
SmartGetHandle9x(
	IN	BYTE	bPhysical,
	OUT PBYTE	pbDeviceNum,
	OUT PGETVERSIONINPARAMS pgetver
	)
{
	HANDLE	hSmart;
	BYTE	bTmp;
	BOOL	bRet;

	pgetver->bVersion = 0;

	if( bPhysical > ATA_SECONDARY_SLAVE ){
		SetLastError( ERROR_FILE_NOT_FOUND );
		return INVALID_HANDLE_VALUE;
	}

	hSmart = CreateFile( "\\\\.\\SMARTVSD", 0, 0, 0, CREATE_NEW, 0, 0 );
	if( hSmart == INVALID_HANDLE_VALUE ){
		return INVALID_HANDLE_VALUE;
	}

	bRet = SmartGetVersion( hSmart, pgetver );
	if( !bRet ){
		CloseHandle( hSmart );
		DEBUGMSG(( "SmartGetHandle9x : Can't get handle SMARTVSD\n" ));
		return INVALID_HANDLE_VALUE;
	}

	/* Is Target IDE Disk? */
	bTmp = (1 << bPhysical) & (pgetver->bIDEDeviceMap & 0x0F);
	if( !bTmp ){
		CloseHandle( hSmart );
		SetLastError(ERROR_INVALID_HANDLE);		// tekitou ;-(
		return INVALID_HANDLE_VALUE;
	}

	/* ATAPI? (00.09.01) */
	if( bTmp & ((pgetver->bIDEDeviceMap & 0xF0)>>4) ){
		CloseHandle( hSmart );
		SetLastError(ERROR_INVALID_HANDLE);		// tekitou ;-(
		return INVALID_HANDLE_VALUE;
	}

	*pbDeviceNum = bPhysical;

	return hSmart;
}


HANDLE
SmartGetHandleNT(
	IN	BYTE	bPhysical,
	OUT PBYTE	pbDeviceNum,
	OUT PGETVERSIONINPARAMS pgetver
	)
{
	BOOL bRet;
	BYTE szTmp[128];
	HANDLE hSmart;
	BYTE bTmp;
	int i;

	pgetver->bVersion = 0;

	wsprintf(szTmp, "\\\\.\\PhysicalDrive%d", bPhysical );
	hSmart = CreateFile( szTmp,
					   GENERIC_READ | GENERIC_WRITE,
					   FILE_SHARE_READ|FILE_SHARE_WRITE,
					   NULL,
					   OPEN_EXISTING,
					   0,
					   NULL );

	if( hSmart == INVALID_HANDLE_VALUE ){
		return INVALID_HANDLE_VALUE;
	}

	bRet = SmartGetVersion( hSmart, pgetver );
	if( !bRet ){
		CloseHandle(hSmart);
		hSmart = INVALID_HANDLE_VALUE;
	}

	*pbDeviceNum = 0;
	bTmp = (pgetver->bIDEDeviceMap & 0x0F);
	for( i=0; i<4; i++ ){
		if( (bTmp>>i)&1 ){
			*pbDeviceNum = i;
			break;
		}
	}

	return hSmart;
}


BOOL
SmartGetVersion(
	IN  HANDLE hDevice,
	OUT PGETVERSIONINPARAMS pgetverparams
	)
{
	BOOL  bRet;
	DWORD cbReturn;

	/* MUST 0 clear!because not working. Why? I can't see document. */
	ZeroMemory( pgetverparams, sizeof(GETVERSIONINPARAMS) );

	/* send command */
	bRet = DeviceIoControl(
				hDevice, SMART_GET_VERSION,
				NULL, 0,
				pgetverparams, sizeof(GETVERSIONINPARAMS),
				&cbReturn, NULL );

	return bRet;
}


/* This function is called S.M.A.R.T. function issue
 * bOperation is TRUE,  SMART ENABLE  OPERATIONS
 * bOperation is FALSE, SMART DISABLE OPERATIONS
 */
BOOL
SmartATAEnableDisableOperation(
	IN  HANDLE	hDevice,
	IN  BYTE	bDeviceNum,
	IN	BOOL	bOperation
	)
{
	BOOL   bRet;
	DWORD  cbReturn;
	SENDCMDINPARAMS sendparamIN;
	SENDCMDOUTPARAMS sendparamOUT;

	ZeroMemory( &sendparamIN,  sizeof(SENDCMDINPARAMS)  );
	ZeroMemory( &sendparamOUT, sizeof(SENDCMDOUTPARAMS) );

	if( bOperation ){
		sendparamIN.irDriveRegs.bFeaturesReg = ENABLE_SMART;
	}else{
		sendparamIN.irDriveRegs.bFeaturesReg = DISABLE_SMART;
	}

	sendparamIN.irDriveRegs.bSectorCountReg		= 1;
	sendparamIN.irDriveRegs.bSectorNumberReg	= 1;
	sendparamIN.irDriveRegs.bCylLowReg			= SMART_CYL_LOW;
	sendparamIN.irDriveRegs.bCylHighReg			= SMART_CYL_HI;

	sendparamIN.irDriveRegs.bDriveHeadReg = ((bDeviceNum & 1)<<4)|0xA0;
	sendparamIN.irDriveRegs.bCommandReg   = SMART_CMD;
	sendparamIN.bDriveNumber              = bDeviceNum;

	sendparamIN.cBufferSize				  = 0;

	/* send command */
	bRet = DeviceIoControl(
				hDevice,
				SMART_SEND_DRIVE_COMMAND,
				&sendparamIN,  sizeof(SENDCMDINPARAMS) - 1,
				&sendparamOUT, sizeof(SENDCMDOUTPARAMS) - 1,
				&cbReturn, NULL
	);

	return bRet;
}


/* This function is called S.M.A.R.T. function issue
 * SMART RETURN STATUS
 * If FALSE returned, your ATA harddisk is found any probrems, maybe :-).
 */
BOOL
SmartATAReturnStatus(
	IN  HANDLE	hDevice,
	IN  BYTE	bDeviceNum
	)
{
	BOOL   bRet;
	DWORD  cbReturn;
	SENDCMDINPARAMS sendparamIN;
	SMART_RETURNSTATUS smart_return;
	DWORD dwSize;

	BOOL bWINNT = IS_NT;

	/* zero clear */
	ZeroMemory( &sendparamIN,  sizeof(SENDCMDINPARAMS)    );
	ZeroMemory( &smart_return, sizeof(SMART_RETURNSTATUS) );

	/* set param */
	sendparamIN.irDriveRegs.bFeaturesReg		= RETURN_SMART_STATUS;
	sendparamIN.irDriveRegs.bSectorCountReg		= 1;
	sendparamIN.irDriveRegs.bSectorNumberReg	= 1;
	sendparamIN.irDriveRegs.bCylLowReg			= SMART_CYL_LOW;
	sendparamIN.irDriveRegs.bCylHighReg			= SMART_CYL_HI;

	sendparamIN.irDriveRegs.bDriveHeadReg = ((bDeviceNum & 1)<<4)|0xA0;
	sendparamIN.irDriveRegs.bCommandReg   = SMART_CMD;
	sendparamIN.bDriveNumber              = bDeviceNum;

	if( bWINNT ){
		sendparamIN.cBufferSize	= sizeof(IDEREGS);
		dwSize = sizeof(SMART_RETURNSTATUS);
	}else{
		sendparamIN.cBufferSize = 0;
		dwSize = sizeof(SENDCMDOUTPARAMS) - 1;
	}

	/* send command */
	bRet = DeviceIoControl(
				hDevice,
				SMART_SEND_DRIVE_COMMAND,
				&sendparamIN,  sizeof(SENDCMDINPARAMS) - 1,
				&smart_return, dwSize,
				&cbReturn, NULL
	);

	if( !bRet ){
		return FALSE;
	}

	if( bWINNT ){
		if( (smart_return.irDriveRegs.bCylLowReg  == SMART_CYL_LOW) &&
			(smart_return.irDriveRegs.bCylHighReg == SMART_CYL_HI ) ){
			return TRUE;
		}
	}else{
		// non-sense ;-(
		if( (sendparamIN.irDriveRegs.bCylLowReg  == SMART_CYL_LOW) &&
			(sendparamIN.irDriveRegs.bCylHighReg == SMART_CYL_HI ) ){
			return TRUE;
		}
	}

	return FALSE;
}


/* This function is called S.M.A.R.T. function issue
 * bOperation is TRUE,  SMART ENABLE  ATTRIBUTE AUTOSAVE
 * bOperation is FALSE, SMART DISABLE ATTRIBUTE AUTOSAVE
 */
BOOL
SmartATAEnableDisableAutosave(
	IN  HANDLE	hDevice,
	IN  BYTE	bDeviceNum,
	IN	BOOL	bOperation
	)
{
	BOOL   bRet;
	DWORD  cbReturn;
	SENDCMDINPARAMS sendparamIN;
	SENDCMDOUTPARAMS sendparamOUT;

	/* zero clear */
	ZeroMemory( &sendparamIN,  sizeof(SENDCMDINPARAMS)  );
	ZeroMemory( &sendparamOUT, sizeof(SENDCMDOUTPARAMS) );

	/* set param */
	if( bOperation ){
		sendparamIN.irDriveRegs.bSectorCountReg = 0xF1;
	}else{
		sendparamIN.irDriveRegs.bSectorCountReg = 0;
	}

	sendparamIN.irDriveRegs.bFeaturesReg		= ENABLE_DISABLE_AUTOSAVE;

	sendparamIN.irDriveRegs.bSectorNumberReg	= 1;
	sendparamIN.irDriveRegs.bCylLowReg			= SMART_CYL_LOW;
	sendparamIN.irDriveRegs.bCylHighReg			= SMART_CYL_HI;

	sendparamIN.irDriveRegs.bDriveHeadReg = ((bDeviceNum & 1)<<4)|0xA0;
	sendparamIN.irDriveRegs.bCommandReg   = SMART_CMD;
	sendparamIN.bDriveNumber              = bDeviceNum;

	sendparamIN.cBufferSize				  = 0;

	/* send command */
	bRet = DeviceIoControl(
				hDevice,
				SMART_SEND_DRIVE_COMMAND,
				&sendparamIN,  sizeof(SENDCMDINPARAMS) - 1,
				&sendparamOUT, sizeof(SENDCMDOUTPARAMS) - 1,
				&cbReturn, NULL
	);

	return bRet;
}


/* This function is called S.M.A.R.T. function issue
 * SMART READ ATTRIBUTE VALUES (ATA-3 only), or
 * SMART READ DATA (above ATA-4)
 */
BOOL
SmartATAReadAttributeValue(
	IN  HANDLE	hDevice,
	IN  BYTE	bDeviceNum,
	OUT PSMART_READ_ATTRIBUTE_VALUE pattrb_value
	)

{
	BOOL   bRet;
	DWORD  cbReturn;
	SENDCMDINPARAMS sendparamIN;

	/* zero clear */
	ZeroMemory( &sendparamIN,  sizeof(SENDCMDINPARAMS) );
	ZeroMemory( pattrb_value, sizeof(SMART_READ_ATTRIBUTE_VALUE) );

	sendparamIN.irDriveRegs.bFeaturesReg		= READ_ATTRIBUTES;
	sendparamIN.irDriveRegs.bSectorCountReg		= 1;
	sendparamIN.irDriveRegs.bSectorNumberReg	= 1;
	sendparamIN.irDriveRegs.bCylLowReg			= SMART_CYL_LOW;
	sendparamIN.irDriveRegs.bCylHighReg			= SMART_CYL_HI;

	sendparamIN.irDriveRegs.bDriveHeadReg = ((bDeviceNum & 1)<<4)|0xA0;
	sendparamIN.irDriveRegs.bCommandReg   = SMART_CMD;
	sendparamIN.bDriveNumber              = bDeviceNum;

	sendparamIN.cBufferSize				  = READ_ATTRIBUTE_BUFFER_SIZE;

	/* send command */
	bRet = DeviceIoControl(
				hDevice,
				SMART_RCV_DRIVE_DATA,
				&sendparamIN,  sizeof(SENDCMDINPARAMS) - 1,
				pattrb_value, sizeof(SMART_READ_ATTRIBUTE_VALUE),
				&cbReturn, NULL
	);

	return bRet;
}



/* This function is called S.M.A.R.T. function issue
 * SMART READ ATTRIBUTE THRESHOLDS (ATA-3 only)
 * Above ATA-4 is OBSOLETE.
 */
BOOL
SmartATAReadAttributeThresholds(
	IN  HANDLE	hDevice,
	IN  BYTE	bDeviceNum,
	OUT PSMART_READ_THRESHOLDS pattrb_thresholds
	)
{
	BOOL   bRet;
	DWORD  cbReturn;
	SENDCMDINPARAMS sendparamIN;

	/* zero clear */
	ZeroMemory( &sendparamIN,  sizeof(SENDCMDINPARAMS) );
	ZeroMemory( pattrb_thresholds, sizeof(SMART_READ_THRESHOLDS) );

	sendparamIN.irDriveRegs.bFeaturesReg		= READ_THRESHOLDS;
	sendparamIN.irDriveRegs.bSectorCountReg		= 1;
	sendparamIN.irDriveRegs.bSectorNumberReg	= 1;
	sendparamIN.irDriveRegs.bCylLowReg			= SMART_CYL_LOW;
	sendparamIN.irDriveRegs.bCylHighReg			= SMART_CYL_HI;

	sendparamIN.irDriveRegs.bDriveHeadReg = ((bDeviceNum & 1)<<4)|0xA0;
	sendparamIN.irDriveRegs.bCommandReg   = SMART_CMD;
	sendparamIN.bDriveNumber              = bDeviceNum;

	sendparamIN.cBufferSize				  = READ_THRESHOLD_BUFFER_SIZE;

	/* send command */
	bRet = DeviceIoControl(
				hDevice,
				SMART_RCV_DRIVE_DATA,
				&sendparamIN,  sizeof(SENDCMDINPARAMS) - 1,
				pattrb_thresholds, sizeof(SMART_READ_THRESHOLDS),
				&cbReturn, NULL
	);

	return bRet;
}


/* This function is called S.M.A.R.T. function issue
 * SMART EXECUTE OFF-LINE IMMEDIATE
 * This function have any subcommands. See smart2k.h.
 */
BOOL
SmartATAOfflineImmediate(
	IN  HANDLE	hDevice,
	IN  BYTE	bDeviceNum,
	IN	BYTE	bSubcommand
	)
{
	BOOL   bRet;
	DWORD  cbReturn;
	SENDCMDINPARAMS sendparamIN;
	SENDCMDOUTPARAMS sendparamOUT;

	/* zero clear */
	ZeroMemory( &sendparamIN,  sizeof(SENDCMDINPARAMS)  );
	ZeroMemory( &sendparamOUT, sizeof(SENDCMDOUTPARAMS) );

	sendparamIN.irDriveRegs.bFeaturesReg		= EXECUTE_OFFLINE_DIAGS;
	sendparamIN.irDriveRegs.bSectorCountReg		= 1;
	sendparamIN.irDriveRegs.bSectorNumberReg	= bSubcommand;
	sendparamIN.irDriveRegs.bCylLowReg			= SMART_CYL_LOW;
	sendparamIN.irDriveRegs.bCylHighReg			= SMART_CYL_HI;

	sendparamIN.irDriveRegs.bDriveHeadReg = ((bDeviceNum & 1)<<4)|0xA0;
	sendparamIN.irDriveRegs.bCommandReg   = SMART_CMD;
	sendparamIN.bDriveNumber              = bDeviceNum;

	sendparamIN.cBufferSize				  = 0;

	/* send command */
	bRet = DeviceIoControl(
				hDevice,
				SMART_SEND_DRIVE_COMMAND,
				&sendparamIN,  sizeof(SENDCMDINPARAMS) - 1,
				&sendparamOUT, sizeof(SENDCMDOUTPARAMS) - 1,
				&cbReturn, NULL
	);

	return bRet;
}


/* This function is called S.M.A.R.T. function issue
 * SMART SAVE ATTRIBUTE VALUES
 */
BOOL
SmartATASaveAttributeValue(
	IN  HANDLE	hDevice,
	IN  BYTE	bDeviceNum
	)
{
	BOOL   bRet;
	DWORD  cbReturn;
	SENDCMDINPARAMS sendparamIN;
	SENDCMDOUTPARAMS sendparamOUT;

	/* zero clear */
	ZeroMemory( &sendparamIN,  sizeof(SENDCMDINPARAMS)  );
	ZeroMemory( &sendparamOUT, sizeof(SENDCMDOUTPARAMS) );

	sendparamIN.irDriveRegs.bFeaturesReg		= SAVE_ATTRIBUTE_VALUES;
	sendparamIN.irDriveRegs.bSectorCountReg		= 1;
	sendparamIN.irDriveRegs.bSectorNumberReg	= 1;
	sendparamIN.irDriveRegs.bCylLowReg			= SMART_CYL_LOW;
	sendparamIN.irDriveRegs.bCylHighReg			= SMART_CYL_HI;

	sendparamIN.irDriveRegs.bDriveHeadReg = ((bDeviceNum & 1)<<4)|0xA0;
	sendparamIN.irDriveRegs.bCommandReg   = SMART_CMD;
	sendparamIN.bDriveNumber              = bDeviceNum;

	sendparamIN.cBufferSize				  = 0;

	/* send command */
	bRet = DeviceIoControl(
				hDevice,
				SMART_SEND_DRIVE_COMMAND,
				&sendparamIN,  sizeof(SENDCMDINPARAMS) - 1,
				&sendparamOUT, sizeof(SENDCMDOUTPARAMS) - 1,
				&cbReturn, NULL
	);

	return bRet;
}

