/*
 * Copyright (C) 2011-2012 Makoto NARA (Mc.N)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.synchack.android.usbhostviewer;

import com.synchack.android.usbhostviewer.fragment.DetailsFragment;
import com.synchack.android.usbhostviewer.menu.MenuId;
import com.synchack.android.usbhostviewer.menu.MenuInfoFragment;
import com.synchack.android.usbhostviewer.menu.MenuShareFragment;
import com.synchack.android.usbhostviewer.menu.MenuShareFragment4ICS;

import android.app.ActionBar;
import android.app.Activity;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.view.MenuItem;

public class DetailsActivity extends Activity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
            finish();
            return;
        }

        // fragment
        FragmentManager fm = getFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();

        if (savedInstanceState == null) {
            DetailsFragment details = new DetailsFragment();
            details.setArguments(getIntent().getExtras());

            ft.add(android.R.id.content, details, DetailsFragment.TAG_FRAG_DETAILS);
        }

        // add menu
        if (null == fm.findFragmentByTag(MenuId.TAG_INFO)) {
            ft.add(new MenuInfoFragment(), MenuId.TAG_INFO);
        }
        if (null == fm.findFragmentByTag(MenuId.TAG_SHARE)) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ICE_CREAM_SANDWICH) {
                ft.add(new MenuShareFragment4ICS(), MenuId.TAG_SHARE);
            } else {
                ft.add(new MenuShareFragment(), MenuId.TAG_SHARE);
            }
        }

        ft.commit();
    }

    @Override
    public void onResume() {
        super.onResume();

        // actionbar
        ActionBar actionbar = getActionBar();
        if (actionbar != null) {
            actionbar.setDisplayShowHomeEnabled(true);
            actionbar.setDisplayHomeAsUpEnabled(true);
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                // actionbar icon
                PackageManager pm = getBaseContext().getPackageManager();
                Intent intent = pm.getLaunchIntentForPackage(getBaseContext().getPackageName());
                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent);

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ECLAIR) {
                    overridePendingTransition(0, 0);
                }
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }
}
