/*
 * Copyright (C) 2011-2012 Makoto NARA (Mc.N)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.synchack.android.usbhostviewer;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.os.Build;
import android.os.Bundle;
import android.text.Html;
import android.text.util.Linkify;
import android.view.MenuItem;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

public class InformationActivity extends Activity {

    private final static String LICENSE_APL20 =
            "Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at"
                    + "<P>http://www.apache.org/licenses/LICENSE-2.0"
                    + "<P>Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.";

    private final static String LICENSE_USBIDS = "The contents of the database and the generated files can be distributed under the terms of either the GNU General Public License (version 2 or later) or of the 3-clause BSD License."
            + "<P>- http://www.opensource.org/licenses/gpl-license.php"
            + "<BR>- http://www.opensource.org/licenses/bsd-license.php";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.information);

        // actionbar
        ActionBar actionbar = getActionBar();
        actionbar.setDisplayShowHomeEnabled(true);
        actionbar.setDisplayHomeAsUpEnabled(true);

        // text
        TextView tvInfo = (TextView) findViewById(R.id.text);
        tvInfo.setAutoLinkMask(Linkify.WEB_URLS);

        // contribution
        ArrayList<License> list = new ArrayList<License>();
        list.add(new License("The USB ID Repository",
                "Maintained by Stephen J. Gowdy <linux.usb.ids@gmail.com>",
                LICENSE_USBIDS));
        tvInfo.setText(Html.fromHtml(makeMyInfo() + makeLicenses(list)));
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                // actionbar icon
                PackageManager pm = getBaseContext().getPackageManager();
                Intent intent = pm.getLaunchIntentForPackage(getBaseContext().getPackageName());
                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent);

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ECLAIR) {
                    overridePendingTransition(0, 0);
                }
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    private String makeMyInfo() {
        final String header = "Information";
        final String name = getBaseContext().getString(R.string.app_name);
        final String author = getBaseContext().getString(R.string.app_author);
        String version = "";

        PackageManager pm = getBaseContext().getPackageManager();
        try {
            PackageInfo info = pm.getPackageInfo(getBaseContext().getPackageName(), 0);
            version = info.versionName;
        } catch (NameNotFoundException e) {
            e.printStackTrace();
        }

        return "<H1>" + header + "</H1>"
                + "<H2>" + name + " " + version + "</H2>"
                + "<P>" + author + "</P>"
                + "<P>" + LICENSE_APL20;
    }

    private String makeLicenses(List<License> licenses) {
        if (licenses.size() < 1) {
            return "";
        }
        String str = "<H1>Open Source Software</H1>"
                + "<P>This software uses following open source software resources.</P>";

        for (License lic : licenses) {
            str += "<H2>" + lic.title + "</H2>"
                    + "<P>" + lic.author + "</P>"
                    + "<P>" + lic.license;
        }
        return str;
    }

    public class License {
        final String title;
        final String author;
        final String license;

        License(String title_, String author_, String license_) {
            title = title_;
            author = author_;
            license = license_;
        }
    }

}
