/*
 * Copyright (C) 2011-2012 Makoto NARA (Mc.N)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.synchack.android.usbhostviewer;

import com.synchack.android.usbhostviewer.fragment.UsbListFragment;
import com.synchack.android.usbhostviewer.menu.MenuId;
import com.synchack.android.usbhostviewer.menu.MenuInfoFragment;
import com.synchack.android.usbhostviewer.menu.MenuRefreshFragment;
import com.synchack.android.usbhostviewer.menu.MenuShareFragment;
import com.synchack.android.usbhostviewer.menu.MenuShareFragment4ICS;

import android.app.Activity;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.os.Bundle;

public class UsbListActivity extends Activity {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        FragmentManager fm = getFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();

        // add menu
        if (null == fm.findFragmentByTag(MenuId.TAG_INFO)) {
            ft.add(new MenuInfoFragment(), MenuId.TAG_INFO);
        }
        if (null == fm.findFragmentByTag(MenuId.TAG_SHARE)) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ICE_CREAM_SANDWICH) {
                ft.add(new MenuShareFragment4ICS(), MenuId.TAG_SHARE);
            } else {
                ft.add(new MenuShareFragment(), MenuId.TAG_SHARE);
            }
        }
        if (null == fm.findFragmentByTag(MenuId.TAG_REFRESH)) {
            ft.add(new MenuRefreshFragment(), MenuId.TAG_REFRESH);
        }

        ft.commit();
    }

    @Override
    public void onResume() {
        super.onResume();

        IntentFilter filter = new IntentFilter();
        filter.addAction(UsbManager.ACTION_USB_DEVICE_ATTACHED);
        filter.addAction(UsbManager.ACTION_USB_DEVICE_DETACHED);
        registerReceiver(mUsbReceiver, filter);
    }

    @Override
    public void onPause() {
        super.onPause();
        unregisterReceiver(mUsbReceiver);
    }

    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver() {
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            UsbListFragment f = (UsbListFragment) getFragmentManager().findFragmentById(
                    R.id.fragment_lists);
            if (f == null) {
                return;
            }
            if (UsbManager.ACTION_USB_DEVICE_ATTACHED.equals(action)) {
                // no received... X-(
                f.refresh(false);
            } else if (UsbManager.ACTION_USB_DEVICE_DETACHED.equals(action)) {
                f.refresh(false);
            }
        }
    };

}
