/*
 * Copyright (C) 2011-2012 Makoto NARA (Mc.N)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.synchack.android.usbhostviewer.fragment;

import com.synchack.android.usbhostviewer.R;
import com.synchack.android.usbhostviewer.UsbidsDB;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import java.util.Map;
import java.util.Map.Entry;

public class UsbListAdapter extends ArrayAdapter<UsbDevice> {

    private final LayoutInflater mInflater;
    private final UsbidsDB mUsbDB;

    public UsbListAdapter(Context context) {
        super(context, R.layout.lists);
        mInflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        mUsbDB = new UsbidsDB(getContext());
    }

    public void setData(Map<String, UsbDevice> devices) {
        clear();
        if (devices != null) {
            for (Entry<String, UsbDevice> dev : devices.entrySet()) {
                UsbDevice udev = dev.getValue();
                add(udev);
            }
        }
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        View view;

        if (convertView == null) {
            view = mInflater.inflate(R.layout.lists, parent, false);
        } else {
            view = convertView;
        }

        UsbDevice udev = getItem(position);
        TextView tvTitle = (TextView) view.findViewById(R.id.title);
        TextView tvSummary = (TextView) view.findViewById(R.id.summary);

        String pname = mUsbDB.getProjectString(udev);
        if (pname.length() < 1) {
            pname = String.format("%04x:%04x", udev.getVendorId(), udev.getProductId());
        }
        String vname = mUsbDB.getVendorString(udev);
        if (vname.length() < 1) {
            vname = String.format("%04x", udev.getVendorId());
        }

        tvTitle.setText(pname);
        tvSummary.setText(vname);

        return view;
    }

}
