/*
 * Copyright (C) 2011-2012 Makoto NARA (Mc.N)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.synchack.android.usbhostviewer.fragment;

import com.synchack.android.usbhostviewer.DetailsActivity;
import com.synchack.android.usbhostviewer.R;
import com.synchack.android.usbhostviewer.util.ELog;

import android.app.ListFragment;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Intent;
import android.content.Loader;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Bundle;
import android.view.View;
import android.widget.ListView;

import java.util.HashMap;

public class UsbListFragment extends ListFragment
        implements LoaderManager.LoaderCallbacks<Boolean> {

    private UsbListAdapter mAdapter;
    boolean mHasDetailsFrame;
    private UsbManager mUsbManager;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);

        mUsbManager = (UsbManager) getActivity().getSystemService(Context.USB_SERVICE);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        ELog.i("onActivityCreated");

        setEmptyText(getString(R.string.error_not_usb_devices));

        mAdapter = new UsbListAdapter(getActivity());
        setListAdapter(mAdapter);

        setListShown(false);

        View detailsFrame = getActivity().findViewById(R.id.frame_details);
        mHasDetailsFrame = (detailsFrame != null) && (detailsFrame.getVisibility() == View.VISIBLE);

        getLoaderManager().initLoader(0, null, this);
    }

    @Override
    public void onListItemClick(ListView l, View v, int position, long id) {

        UsbDevice udev = mAdapter.getItem(position);

        if (udev != null) {
            if (mHasDetailsFrame) {
                DetailsFragment df = DetailsFragment.newInstance(udev);
                getFragmentManager()
                        .beginTransaction()
                        .replace(R.id.frame_details, df, DetailsFragment.TAG_FRAG_DETAILS)
                        .setTransition(android.app.FragmentTransaction.TRANSIT_FRAGMENT_FADE)
                        .commit();
            } else {
                Intent intent = new Intent(getActivity(), DetailsActivity.class);
                intent.putExtra("udev", udev);
                startActivity(intent);
            }
        }
    }

    @Override
    public Loader<Boolean> onCreateLoader(int id, Bundle args) {
        ELog.i("onCreateLoader");
        return new UsbListLoader(getActivity());
    }

    @Override
    public void onLoadFinished(Loader<Boolean> loader, Boolean data) {
        ELog.i("onLoadFinished");

        refresh(true);

        if (isResumed()) {
            setListShown(true);
        } else {
            setListShownNoAnimation(true);
        }
    }

    @Override
    public void onLoaderReset(Loader<Boolean> loader) {
        ELog.i("onLoaderReset");
        mAdapter.setData(null);
    }

    public void refresh(boolean isLoader) {
        if (mUsbManager != null && mAdapter != null) {
            HashMap<String, UsbDevice> devices = mUsbManager.getDeviceList();
            mAdapter.setData(devices);
            mAdapter.notifyDataSetChanged();
        }

        if (!isLoader && mHasDetailsFrame) {
            DetailsFragment df = DetailsFragment.newInstance(null);
            getFragmentManager()
                    .beginTransaction()
                    .replace(R.id.frame_details, df, DetailsFragment.TAG_FRAG_DETAILS)
                    .setTransition(android.app.FragmentTransaction.TRANSIT_FRAGMENT_FADE)
                    .commit();
        }
    }

}
