/*
 * Copyright (C) 2011-2012 Makoto NARA (Mc.N)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.synchack.android.usbhostviewer.fragment;

import com.synchack.android.usbhostviewer.UsbidsDB;
import com.synchack.android.usbhostviewer.util.ELog;

import android.content.AsyncTaskLoader;
import android.content.Context;

public class UsbListLoader extends AsyncTaskLoader<Boolean> {

    private final UsbidsDB mUsbdb;

    public UsbListLoader(Context context) {
        super(context);
        // init database
        mUsbdb = new UsbidsDB(getContext());
    }

    @Override
    public Boolean loadInBackground() {

        if (mUsbdb.isRemakeDB()) {
            // remake db! very long time X-(
            mUsbdb.makeDB();
        }
        
        return Boolean.TRUE;
    }

    @Override
    public void deliverResult(Boolean bret) {
        ELog.i("deliverResult");
        super.deliverResult(bret);
    }

    @Override
    protected void onStartLoading() {
        ELog.i("onStartLoading");
        if( mUsbdb.isRemakeDB() ){
            onForceLoad();            
        }else{
            deliverResult(Boolean.TRUE);
        }
    }
}
