/*
 * Copyright (C) 2011-2012 Makoto NARA (Mc.N)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.synchack.android.usbhostviewer.menu;

import com.synchack.android.usbhostviewer.R;
import com.synchack.android.usbhostviewer.fragment.DetailsFragment;

import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.Toast;

public class MenuShareFragment extends Fragment {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
    }

    @Override
    public void onPrepareOptionsMenu(Menu menu) {
        super.onPrepareOptionsMenu(menu);
    }

    @Override
    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
        
        MenuItem menushare = menu.add(Menu.NONE, MenuId.SHARE, Menu.NONE, R.string.menu_share);
        menushare.setIcon(android.R.drawable.ic_menu_share);
        menushare.setShowAsAction(MenuItem.SHOW_AS_ACTION_IF_ROOM);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case MenuId.SHARE:
                kick_share_details();
                return true;
        }

        return super.onOptionsItemSelected(item);
    }

    private void kick_share_details() {
        String usbdump = getUsbDump();

        if (usbdump != null && usbdump.length() > 0) {
            startActivity(createShareIntent(usbdump));
        } else {
            Toast.makeText(getActivity(), R.string.error_not_share_data, Toast.LENGTH_LONG).show();
        }
    }

    // for ICS
    protected Intent createShareIntent() {
        String usbdump = getUsbDump();
        return usbdump.length() > 0 ? createShareIntent(usbdump) : null;
    }

    private Intent createShareIntent(String usbdump) {
        Intent intent = new Intent(Intent.ACTION_SEND);
        intent.setType("text/plain");
        intent.putExtra(Intent.EXTRA_TEXT, usbdump);
        return intent;
    }

    private String getUsbDump() {

        String str = "";

        DetailsFragment f = (DetailsFragment) getFragmentManager().findFragmentByTag(
                DetailsFragment.TAG_FRAG_DETAILS);

        if (f == null) {
            return str;
        }

        str = f.getUsbDump();
        if (str == null || str.length() < 1) {
            return str;
        }

        return str;
    }

}
