/*
 * MyHID.c
 * 01.05.28 : Makoto NARA(Mc.N)
 */

/*
 * Copyright (c) 2001 Makoto NARA(Mc.N) All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY Makoto NARA(Mc.N) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




#include "mydbg.h"

// DWORD dwDebugLevel = DBG_ERROR;
DWORD dwDebugLevel = DBG_NOINFO;

void
DbgMessage(
	LPCSTR	ptsz, ...
	)
{
	va_list ap;
	TCHAR tsz[1024];
	va_start(ap, ptsz);
	wvsprintf(tsz, ptsz, ap);
	va_end(ap);
	OutputDebugStringA(tsz);
#if DBG_MESSAGEBOX
	MessageBoxA( NULL, tsz, "Debug message", MB_OK | MB_ICONERROR );
#endif // DBG_MESSAGEBOX

	return;
}

HGLOBAL
MyAlloc(
	SIZE_T dwBytes
	)
{
	HGLOBAL hGlobal;

	hGlobal = GlobalAlloc( GPTR, dwBytes );
	if( hGlobal == NULL ){
		DBGMSG( DBG_ERROR, ("Error : cannot alloc memory[%d]\n", GetLastError()) );
	}else{
		DBGMSG( DBG_NOINFO, ("Info : alloc memory[%0X]\n", hGlobal) );
	}


	return hGlobal;
}

HGLOBAL
MyFree(
	HGLOBAL hMem
	)
{
	HGLOBAL hGlobal;

	hGlobal = GlobalFree(hMem);
	if( hGlobal != NULL ){
		DBGMSG( DBG_ERROR, ("Error : cannot free memory[%d]\n", GetLastError()) );
	}else{
		DBGMSG( DBG_NOINFO, ("Info : free memory[%0X]\n", hMem) );
	}

	return hGlobal;
}