/*
 * MyDBG.h
 * 01.05.28 : Makoto NARA(Mc.N)
 */

/*
 * Copyright (c) 2001 Makoto NARA(Mc.N) All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY Makoto NARA(Mc.N) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




#ifndef _MYDEBUG_H
#define _MYDEBUG_H

#include <windows.h>

// console setting
#ifdef _CONSOLE
#include <stdio.h>
//#define MYDBG
#define MYDBG_STDOUT
#endif // _CONSOLE


#define DBG_NOINFO	(0x0)
#define DBG_INFO	(0x2)
#define DBG_ERROR	(0x4)
#define DBG_ASSERT  (0x8 | DBG_ERROR)
extern DWORD dwDebugLevel;


void
DbgMessage(
	LPCSTR	ptsz, ...
	);

HGLOBAL
MyAlloc(
	SIZE_T dwBytes
	);

HGLOBAL
MyFree(
	HGLOBAL hMem
	);


#ifdef _DEBUG
#define MYDBG
#endif
#ifdef DBG
#define MYDBG
#endif

#ifdef MYDBG
#ifdef MYDBG_STDOUT
#define DBGMSG(lv,arg) if( dwDebugLevel != DBG_NOINFO ){ printf arg; }
#else
#define DBGMSG(lv,arg)								\
	if( lv != DBG_NOINFO && (lv&dwDebugLevel) ){	\
		DbgMessage arg;								\
		if( lv == DBG_ASSERT ){ DebugBreak(); }		\
	}
#endif // DBG_STDOUT
#define MYALLOC(dw) MyAlloc(dw)
#define MYFREE(dw)  MyFree(dw)
#else  // MYDBG
#define MYALLOC(dw) GlobalAlloc(GPTR,dw);
#define MYFREE(addr)  GlobalFree(addr);
#define DBGMSG(lv,arg)
#endif // MYDBG

#define MYFREEEX(addr)				\
	if( addr != NULL ){				\
		addr=(PVOID)MYFREE(addr);	\
	}

#endif // _MYDEBUG_H


#if 0
//	DBGMSG( DBG_ERROR, ("Error![%s,%d]", __FILE__, __LINE__) );
// DBGMSG( DBG_ERROR, ("") );

	DBGMSG( DBG_INFO, ("Info : HID GUID = ") );
	DBGMSG( DBG_INFO, ("{%08X-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X}\n",			\
				hidGuid.Data1, hidGuid.Data2, hidGuid.Data3,							\
				hidGuid.Data4[0], hidGuid.Data4[1], hidGuid.Data4[2], hidGuid.Data4[3],	\
				hidGuid.Data4[4], hidGuid.Data4[5], hidGuid.Data4[6], hidGuid.Data4[7]) );
#endif
