/*
 * MyHID.c
 * 01.05.28 : Makoto NARA(Mc.N)
 */

/*
 * Copyright (c) 2001 Makoto NARA(Mc.N) All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY Makoto NARA(Mc.N) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


/* I-N-C-L-U-D-E */
#include "myhid.h"




BOOL
FindUSBFromVendorID(
	IN	PMYHID_USB_DATABASE pmyhid,
	IN  DWORD dwVendorID,
	IN  DWORD dwProductID,
	IN	DWORD dwMember,
	OUT	PDWORD pdwRet
	)
{
	DWORD dwCount;
	BOOL  bRet = FALSE;

	for( dwCount=dwMember; (pmyhid->dwIndex)>dwCount; dwCount++ ){
		if( (pmyhid->pmyhid_usb[dwCount]->hid_attr.VendorID  == dwVendorID) &&
			(pmyhid->pmyhid_usb[dwCount]->hid_attr.ProductID == dwProductID) ){
			bRet = TRUE;
			*pdwRet = dwCount;
			break;
		}

	}

	return bRet;
}




BOOL
OpenHIDdatabase(
	PMYHID_USB_DATABASE pmyhid
	)
{
	GUID		hidGuid;
	HDEVINFO	hdevinfo;
	SP_INTERFACE_DEVICE_DATA			device_data;
	BOOL		bRet, bResult;
	DWORD		dwIndex;
	PSP_DEVICE_INTERFACE_DETAIL_DATA	pdevice_detail;
    ULONG		dwSize;
    ULONG		dwNeeded;
	DWORD		dwErr;
	HANDLE		hHid;
	SECURITY_ATTRIBUTES sa;
	int iLen;

	// Get hid GUID
	HidD_GetHidGuid(&hidGuid);

	// Open PnP Handle
	hdevinfo = SetupDiGetClassDevs( &hidGuid, NULL,	NULL, (DIGCF_PRESENT | DIGCF_INTERFACEDEVICE) );
	if( hdevinfo == INVALID_HANDLE_VALUE ){
		DBGMSG( DBG_ERROR, ("Error : SetupDiGetClassDevs() [%d]\n", GetLastError()) );
		return FALSE;
	}

	bResult = TRUE;
	for( dwIndex=0; dwIndex<MAX_ENUM_INDEX; dwIndex++ ){
		// Enum hid devices
		ZeroMemory( &device_data, sizeof(device_data) );
		device_data.cbSize = sizeof(device_data);
		bRet = SetupDiEnumDeviceInterfaces( hdevinfo, NULL, &hidGuid, dwIndex, &device_data );
		if( !bRet ){
			dwErr = GetLastError();
			if( dwErr == ERROR_NO_MORE_ITEMS ){
				DBGMSG( DBG_INFO, ("Info : No more enum devices\n") );
				bResult = TRUE;
			}else{
				DBGMSG( DBG_ERROR, ("Error : SetupDiEnumDeviceInterfaces()[%d]", dwErr) );
				bResult = FALSE;
			}
			break;
		}

		// Request SP_DEVICE_INTERFACE_DETAIL_DATA size
		dwNeeded = 0;
		bRet = SetupDiGetDeviceInterfaceDetail( hdevinfo, &device_data, NULL, 0, &dwNeeded, NULL );
		dwSize = dwNeeded;
		pdevice_detail = (PSP_DEVICE_INTERFACE_DETAIL_DATA) MYALLOC(dwSize);
		if( pdevice_detail == NULL ){
			bResult = FALSE;
			break;
		}
		pdevice_detail->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);

		// Get SP_DEVICE_INTERFACE_DETAIL_DATA
		bRet = SetupDiGetDeviceInterfaceDetail( hdevinfo, &device_data, pdevice_detail, dwSize, &dwNeeded, NULL );

		if( bRet ){
			// for w2k patch
			sa.nLength = sizeof(SECURITY_ATTRIBUTES);
			sa.lpSecurityDescriptor = NULL;
			sa.bInheritHandle = FALSE;

			// CreateFile
			hHid = CreateFile(	pdevice_detail->DevicePath,
								0,
								FILE_SHARE_READ|FILE_SHARE_WRITE,
								&sa, OPEN_EXISTING, 0, NULL );

			if( hHid != INVALID_HANDLE_VALUE ){
				// Get hid data...
				pmyhid->pmyhid_usb[pmyhid->dwIndex] = (PMYHID_USB)MYALLOC(sizeof(MYHID_USB));
				if( pmyhid->pmyhid_usb[pmyhid->dwIndex] != NULL ){
					iLen = lstrlen(pdevice_detail->DevicePath);
					pmyhid->pmyhid_usb[pmyhid->dwIndex]->pszPath = MYALLOC(iLen+1);
					if( pmyhid->pmyhid_usb[pmyhid->dwIndex]->pszPath != NULL ){
						lstrcpyn( pmyhid->pmyhid_usb[pmyhid->dwIndex]->pszPath, pdevice_detail->DevicePath, iLen+1 );
						bRet = GetHIDdata( hHid, pmyhid->pmyhid_usb[pmyhid->dwIndex] );
						pmyhid->dwIndex++;
					}else{
						bResult = FALSE;
					}
				}else{
					bResult = FALSE;
				}

				CloseHandle(hHid);
				hHid = INVALID_HANDLE_VALUE;
			}else{
				DBGMSG( DBG_INFO, ("Error : CreateFile()[%d]\n", GetLastError()) );
			}
		}

		// free memory
		MYFREEEX(pdevice_detail);
		// Fail?
		if( !bResult ){ break; }
	}

	// close hdevinfo, don"t forget.
	SetupDiDestroyDeviceInfoList(hdevinfo);

	if( !bResult ){
		// clean memory
		CloseHIDdatabase(pmyhid);
	}

	return bResult;
}


BOOL
GetHIDdata(
	HANDLE		hHid,
	PMYHID_USB	pmyhid_usb
	)
{
	BOOL bRet;
	NTSTATUS ntstat;

	// Get hid device of VendorID and ProductID
	pmyhid_usb->hid_attr.Size = sizeof(HIDD_ATTRIBUTES);
	bRet = HidD_GetAttributes( hHid, &(pmyhid_usb->hid_attr) );
	if( bRet ){
		DBGMSG( DBG_INFO, ("Info : Found USB[%04X,%04X]\n",	\
				pmyhid_usb->hid_attr.VendorID,				\
				pmyhid_usb->hid_attr.ProductID) );
	}

	// Open HIDP_PREPARSED_DATA
	if( HidD_GetPreparsedData( hHid, &(pmyhid_usb->pprepared_data) ) ){
		ntstat = HidP_GetCaps(pmyhid_usb->pprepared_data, &(pmyhid_usb->hidp_caps));
		if( ntstat == HIDP_STATUS_SUCCESS ){
			DBGMSG( DBG_INFO, ("Info : Success HidP_GetCaps()\n") );
			DBGMSG( DBG_INFO, ("-----\n") );
			DBGMSG( DBG_INFO, ("  Usage     : [%d]\n", pmyhid_usb->hidp_caps.Usage) );
			DBGMSG( DBG_INFO, ("  UsagePage : [%d]\n", pmyhid_usb->hidp_caps.UsagePage) );
			DBGMSG( DBG_INFO, ("  InputReportByteLength    : [%d]\n", pmyhid_usb->hidp_caps.InputReportByteLength) );
			DBGMSG( DBG_INFO, ("  OutputReportByteLength   : [%d]\n", pmyhid_usb->hidp_caps.OutputReportByteLength) );
			DBGMSG( DBG_INFO, ("  InputReportByteLength    : [%d]\n", pmyhid_usb->hidp_caps.InputReportByteLength) );
			DBGMSG( DBG_INFO, ("  OutputReportByteLength   : [%d]\n", pmyhid_usb->hidp_caps.OutputReportByteLength) );
			DBGMSG( DBG_INFO, ("  FeatureReportByteLength  : [%d]\n", pmyhid_usb->hidp_caps.FeatureReportByteLength) );
			DBGMSG( DBG_INFO, ("  NumberLinkCollectionNodes: [%d]\n", pmyhid_usb->hidp_caps.NumberLinkCollectionNodes) );
			DBGMSG( DBG_INFO, ("  NumberInputButtonCaps    : [%d]\n", pmyhid_usb->hidp_caps.NumberInputButtonCaps) );
			DBGMSG( DBG_INFO, ("  NumberInputValueCaps     : [%d]\n", pmyhid_usb->hidp_caps.NumberInputValueCaps) );
			DBGMSG( DBG_INFO, ("  NumberInputDataIndices   : [%d]\n", pmyhid_usb->hidp_caps.NumberInputDataIndices) );
			DBGMSG( DBG_INFO, ("  NumberOutputButtonCaps   : [%d]\n", pmyhid_usb->hidp_caps.NumberOutputButtonCaps) );
			DBGMSG( DBG_INFO, ("  NumberOutputValueCaps    : [%d]\n", pmyhid_usb->hidp_caps.NumberOutputValueCaps) );
			DBGMSG( DBG_INFO, ("  NumberOutputDataIndices  : [%d]\n", pmyhid_usb->hidp_caps.NumberOutputDataIndices) );
			DBGMSG( DBG_INFO, ("  NumberFeatureButtonCaps  : [%d]\n", pmyhid_usb->hidp_caps.NumberFeatureButtonCaps) );
			DBGMSG( DBG_INFO, ("  NumberFeatureValueCaps   : [%d]\n", pmyhid_usb->hidp_caps.NumberFeatureValueCaps) );
			DBGMSG( DBG_INFO, ("  NumberFeatureDataIndices : [%d]\n", pmyhid_usb->hidp_caps.NumberFeatureDataIndices) );
			DBGMSG( DBG_INFO, ("-----\n") );
		}
	}else{
		pmyhid_usb->pprepared_data = NULL;
	}

	return TRUE;
}




BOOL
CloseHIDdatabase(
	PMYHID_USB_DATABASE pmyhid
	)
{
	DWORD	dw;

	for( dw=0; dw<(pmyhid->dwIndex); dw++ ){
		if( pmyhid->pmyhid_usb[dw] == NULL ){
			continue;
		}
		MYFREEEX(pmyhid->pmyhid_usb[dw]->pszPath);
		// Close HIDP_PREPARSED_DATA
		if( pmyhid->pmyhid_usb[dw]->pprepared_data != NULL ){
			HidD_FreePreparsedData(pmyhid->pmyhid_usb[dw]->pprepared_data);
		}
		MYFREEEX(pmyhid->pmyhid_usb[dw]);
	}

	return TRUE;
}

