/*
 * MyHID.h
 * 01.05.28 : Makoto NARA(Mc.N)
 */

/*
 * Copyright (c) 2001 Makoto NARA(Mc.N) All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY Makoto NARA(Mc.N) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef _MYHID_H
#define _MYHID_H


/* I-N-C-L-U-D-E */

#include <windows.h>
#include <setupapi.h>
// #include "hidsdi.h"
#include <hidsdi.h>
#include "mydbg.h"




/* D-E-F-I-N-E */

#define MAX_ENUM_INDEX		(128)


/* T-Y-P-E-D-E-F */
typedef struct _MYHID_USB{
	LPTSTR					pszPath;	// pdevice_detail->DevicePath
	PHIDP_PREPARSED_DATA	pprepared_data;
	HIDD_ATTRIBUTES			hid_attr;	//
	HIDP_CAPS				hidp_caps;	// pointer of HIDP_CAPS
} MYHID_USB, *PMYHID_USB;


typedef struct _MYHID_USB_DATABASE{
	DWORD		dwIndex;					// MemberIndex
	PMYHID_USB	pmyhid_usb[MAX_ENUM_INDEX];	//
} MYHID_USB_DATABASE, *PMYHID_USB_DATABASE;


/* P-R-O-T-O T-Y-P-E */

BOOL
FindUSBFromVendorID(
	IN	PMYHID_USB_DATABASE pmyhid,
	IN  DWORD dwVendorID,
	IN  DWORD dwProductID,
	IN	DWORD dwMember,
	OUT	PDWORD pdwRet
	);

BOOL
OpenHIDdatabase(
	PMYHID_USB_DATABASE pmyhid
	);

BOOL
CloseHIDdatabase(
	PMYHID_USB_DATABASE pmyhid
	);

BOOL
GetHIDdata(
	HANDLE		hHid,
	PMYHID_USB	pmyhid_usb
	);




#endif // _MYHID_H

