/*
 * USB-IO test program
 * 01.05.28 : Makoto NARA(Mc.N)
 * Histry :
 * 01.05.28 : First release (ver.0.01)
 */

/*
 * Copyright (c) 2001 Makoto NARA(Mc.N) All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY Makoto NARA(Mc.N) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




/* I-N-C-L-U-D-E */
#include <stdio.h>
#include <windows.h>
#include "usbio.h"



/* P-R-O-T-O T-Y-P-E */
void Usage(void);

void
EnumUSB_IO(
	PMYHID_USB_DATABASE pmyhid
	);

BOOL
FindUSB_IO(
	IN	PMYHID_USB_DATABASE pmyhid,
	IN	DWORD dwMember,
	OUT	PDWORD pdwRet
	);

BOOL
ReadUSB_IO(
	IN BYTE  bCommand,
	IN PBYTE pbData,
	OUT PMYHID_USB pmyhid_usb
	);

BOOL
WriteUSB_IO(
	IN BYTE bCommand,
	IN BYTE bPort,
	OUT PMYHID_USB pmyhid_usb
	);




int
__cdecl
main(
	int	argc,
	char* argv[]
	)
{
	MYHID_USB_DATABASE myhiddb;
	BOOL  bRet;
	DWORD dwRet;

	int i;
	BOOL bVerbose = FALSE;
	BOOL bEnum    = FALSE;
	BOOL bRead    = FALSE;
	BOOL bWrite   = FALSE;
	BYTE bCmd     = 0;
	BYTE bData    = 0;
	BYTE dwSelect = 1;
	UINT uiNum    = 0;


	if( argc < 2 ){ Usage(); return 1; }


	for( i=1; i<argc; i++ ){
		if( 0 == strcmp(argv[i], "-h") )   { Usage(); return 1; }
		if( 0 == strcmp(argv[i], "-enum") ){ bEnum = TRUE; break; }
		if( 0 == strcmp(argv[i], "-verbose") ){ bVerbose = TRUE; continue; }
		// select device
		if( 0 == strcmp(argv[i], "-s1") ){ dwSelect = 1; continue; }
		if( 0 == strcmp(argv[i], "-s2") ){ dwSelect = 2; continue; }
		if( 0 == strcmp(argv[i], "-s3") ){ dwSelect = 3; continue; }
		if( 0 == strcmp(argv[i], "-s4") ){ dwSelect = 4; continue; }

		// read command
		if( 0 == strcmp(argv[i], "-r0")   ){ bRead = TRUE; bCmd = USBIO_READ_P0; continue; }
		if( 0 == strcmp(argv[i], "-r1")   ){ bRead = TRUE; bCmd = USBIO_READ_P1; continue; }
		if( 0 == strcmp(argv[i], "-r0p10")){ bRead = TRUE; bCmd = USBIO_READ_P0_P10; continue; }
		if( 0 == strcmp(argv[i], "-r0p11")){ bRead = TRUE; bCmd = USBIO_READ_P0_P11; continue; }
		if( 0 == strcmp(argv[i], "-r0p12")){ bRead = TRUE; bCmd = USBIO_READ_P0_P12; continue; }
		if( 0 == strcmp(argv[i], "-r0p13")){ bRead = TRUE; bCmd = USBIO_READ_P0_P13; continue; }

		// write command
		if( 0 == strcmp(argv[i], "-w0") )   { bWrite = TRUE; bCmd = USBIO_WRITE_P0; goto writeparse; }
		if( 0 == strcmp(argv[i], "-w1") )   { bWrite = TRUE; bCmd = USBIO_WRITE_P1; goto writeparse; }
		if( 0 == strcmp(argv[i], "-w0p10") ){ bWrite = TRUE; bCmd = USBIO_WRITE_P0_P10; goto writeparse; }
		if( 0 == strcmp(argv[i], "-w0p11") ){ bWrite = TRUE; bCmd = USBIO_WRITE_P0_P11; goto writeparse; }
		if( 0 == strcmp(argv[i], "-w0p12") ){ bWrite = TRUE; bCmd = USBIO_WRITE_P0_P12; goto writeparse; }
		if( 0 == strcmp(argv[i], "-w0p13") ){ bWrite = TRUE; bCmd = USBIO_WRITE_P0_P13; goto writeparse; }

		// invalid parameter
		printf( "Warning : Invalid parameter[%s]\n", argv[i] );
		continue;
		// write data parse
writeparse:
		i++;
		if( argc>i ){
			sscanf( argv[i], "%x", &uiNum );
			if( uiNum < 0x100 ){
				bData = (BYTE)(uiNum&0xFF);
			}else{
				printf( "Error : Invalid parameter[%s]\n\n", argv[i] );
				Usage();
				return 1;
			}
			continue;
		}else{
			printf( "Error : Invalid parameter\n\n" );
			Usage();
			return 1;
		}
	}


	myhiddb.dwIndex = 0;
	bRet = OpenHIDdatabase( &myhiddb );
	if( !bRet ){
		printf("Error : OpenHIDdatabase() is FALSE\n");
		return -1;
	}

	bRet = FALSE;
	if( bEnum ){
		EnumUSB_IO(&myhiddb);
	}else if( bWrite ){
		if( FindUSB_IO( &myhiddb, dwSelect, &dwRet ) ){
			bRet = WriteUSB_IO( bCmd, bData, myhiddb.pmyhid_usb[dwRet] );
			if( bVerbose ){
				if( bRet ){
					printf("Success : USB-IO Written[%02X]\n", bData);
				}else{
					printf("Error : USB-IO CAN'T Written [%02X]\n", bData);
				}
			}
		}else{ 
			if( bVerbose ){printf("Error : Cant Found USB-IO\n");}
		}
	}else if( bRead ){
		if( FindUSB_IO( &myhiddb, dwSelect, &dwRet ) ){
			bRet = ReadUSB_IO( bCmd, &bData, myhiddb.pmyhid_usb[dwRet] );
			if( bVerbose ){
				if( bRet ){
					printf("Success : USB-IO Read data [%02X]\n", bData);
				}else{
					printf("Error : USB-IO CAN'T Read data [%02X]\n", bData);
				}
			}else{
				if( bRet ){printf("%02X\n", bData);}
			}
		}else{ 
			if( bVerbose ){printf("Error : Cant Found USB-IO\n");}
		}
	}else{
		Usage();
	}

	CloseHIDdatabase(&myhiddb);
	if(!bRet){
		return 1;
	}
	return 0;
}




void
Usage(void)
{
	printf( "USB-IO Utility ver.%d.%02d\n", USBIO_VERSION/100, USBIO_VERSION%100 );
	printf( "  -w0 xx : P0 write, xx is hex.\n" );
	printf( "  -w1 xx : P1 write\n" );
	printf( "  -r0    : P0 read\n"  );
	printf( "  -r1    : P1 read\n"  );
	printf( "  (follow this flug is above Ver.2 firmware)\n" );
	printf( "  -w0p10 xx : pulse P1_0, write P0\n" );
	printf( "  -w0p11 xx : pulse P1_1, write P0\n" );
	printf( "  -w0p12 xx : pulse P1_2, write P0\n" );
	printf( "  -w0p13 xx : pulse P1_3, write P0\n" );
	printf( "  -r0p10    : pulse P1_0, read P0\n" );
	printf( "  -r0p11    : pulse P1_1, read P0\n" );
	printf( "  -r0p12    : pulse P1_2, read P0\n" );
	printf( "  -r0p13    : pulse P1_3, read P0\n" );
	printf( "\n" );
	printf( "  -verbose : verbose display\n" );
	printf( "  -s?      : USB-IO select. ? is enumlation number(1-4, default is 1)\n" );
	printf( "\n" );
	printf( "  -h       : display help message(this!)\n" );
	printf( "  -enum    : enumerate USB-IO devices\n" );
	printf( "\n" );
	printf( "  (ex.) -s1 -w0 FE : USB-IO select is 1, P0 written 0xFE\n" );

	return;
}




void
EnumUSB_IO(
	PMYHID_USB_DATABASE pmyhid
	)
{
	DWORD dw;
	DWORD dwCount = 0;

	for( dw=0; dw<pmyhid->dwIndex; dw++ ){
		// morphy?
		if( (pmyhid->pmyhid_usb[dw]->hid_attr.VendorID  == USBIO_VENDORID) ){
			// USB-IO ver.2
			if( pmyhid->pmyhid_usb[dw]->hid_attr.ProductID == USBIO_PRODUCTID_V2 ){
				dwCount++;
				printf( "Device[%d](%d) : USB-IO ver.2 is FOUND\n", dwCount, dw );
				continue;
			}
			// USB-IO ver.1
			if( pmyhid->pmyhid_usb[dw]->hid_attr.ProductID == USBIO_PRODUCTID_V1 ){
				dwCount++;
				printf( "Device[%d](%d) : USB-IO ver.1 is FOUND\n", dwCount, dw );
				continue;
			}	
		}
	}

	if( dwCount == 0 ){
		printf("USB-IO Device is NOT FOUND\n");
	}

	return;
}




BOOL
FindUSB_IO(
	IN	PMYHID_USB_DATABASE pmyhid,
	IN	DWORD dwMember,
	OUT	PDWORD pdwRet
	)
{
	DWORD dw;
	DWORD dwCount = 0;
	BOOL  bRet = FALSE;

	for( dw=0; dw<pmyhid->dwIndex; dw++ ){
		// morphy?
		if( (pmyhid->pmyhid_usb[dw]->hid_attr.VendorID  == USBIO_VENDORID) ){
			// USB-IO ver.2
			if( pmyhid->pmyhid_usb[dw]->hid_attr.ProductID == USBIO_PRODUCTID_V2 ){
				dwCount++;
				if( dwMember == dwCount ){
					*pdwRet = dw;
					bRet    = TRUE;
					break;
				}
				continue;
			}
			// USB-IO ver.1
			if( pmyhid->pmyhid_usb[dw]->hid_attr.ProductID == USBIO_PRODUCTID_V1 ){
				dwCount++;
				if( dwMember == dwCount ){
					*pdwRet = dw;
					bRet    = TRUE;
					break;
				}
				continue;
			}	
		}
	}

	return bRet;
}




BOOL
ReadUSB_IO(
	IN BYTE  bCommand,
	IN PBYTE pbData,
	OUT PMYHID_USB pmyhid_usb
	)
{
	SECURITY_ATTRIBUTES sa;
	BOOL bRet;
	PBYTE pbBuf;
	DWORD dwWritten;
	HANDLE hHid  = INVALID_HANDLE_VALUE;
	BOOL bResult = FALSE;


	// Check write&read data caps
	if( (pmyhid_usb==NULL) ||
		(pbData==NULL)     ||
		(pmyhid_usb->hidp_caps.OutputReportByteLength==0) ||
		(pmyhid_usb->hidp_caps.OutputReportByteLength<9)  ||
		(pmyhid_usb->hidp_caps.InputReportByteLength==0)  ||
		(pmyhid_usb->hidp_caps.InputReportByteLength<2)
		){
		DBGMSG( DBG_ERROR, ("Error : ReadUSB_IO() Invalid data PMYHID_USB!\n") );
		return FALSE;
	}

	for(;;){
		// Write command data
		pbBuf = MYALLOC(pmyhid_usb->hidp_caps.OutputReportByteLength+1);
		if( pbBuf == NULL ){
			DBGMSG( DBG_ERROR, ("Error : ReadUSB_IO() can't get memory [%d]\n", GetLastError()) );
			break;
		}

		sa.nLength = sizeof(SECURITY_ATTRIBUTES);
		sa.lpSecurityDescriptor = NULL;
		sa.bInheritHandle = FALSE;

		hHid = CreateFile(	pmyhid_usb->pszPath,
							GENERIC_READ|GENERIC_WRITE,
							FILE_SHARE_READ|FILE_SHARE_WRITE,
							&sa, OPEN_EXISTING, 0, NULL );

		if( hHid == INVALID_HANDLE_VALUE ){
			DBGMSG( DBG_ERROR, ("Error : CreateFile()[%d]\n", GetLastError()) );
			DBGMSG( DBG_ERROR, ("Error : port name [%s]\n", pmyhid_usb->pszPath) );
			break;
		}
		
		*(pbBuf+0) = 0;			// Report ID is no mentenance
		*(pbBuf+1) = bCommand;	// command id
		*(pbBuf+2) = 0;			// dummy
		*(pbBuf+3) = 0xF1;		// dummy
		*(pbBuf+4) = 0xF2;
		*(pbBuf+5) = 0xF3;
		*(pbBuf+6) = 0xF4;
		*(pbBuf+7) = 0xF5;

		// Write command...
		bRet = WriteFile( hHid, pbBuf, pmyhid_usb->hidp_caps.OutputReportByteLength, &dwWritten, NULL );
		if( !bRet ){
			DBGMSG( DBG_ERROR, ("Error : WriteFile()[%d]\n", GetLastError()) );
			break;
		}

		MYFREEEX(pbBuf);

		// Read command data
		pbBuf = MYALLOC(pmyhid_usb->hidp_caps.InputReportByteLength+1);
		if( pbBuf == NULL ){
			DBGMSG( DBG_ERROR, ("Error : ReadUSB_IO() can't get memory [%d]\n", GetLastError()) );
			break;
		}

		// Refresh Read buffer
		HidD_FlushQueue(hHid);

		// Read USB-IO
		bRet = ReadFile( hHid, pbBuf, pmyhid_usb->hidp_caps.InputReportByteLength, &dwWritten, NULL );
		if( !bRet ){
			DBGMSG( DBG_ERROR, ("Error : ReadFile()[%d]\n", GetLastError()) );
			break;
		}

		// success
		*pbData = *(pbBuf+2);
		bResult = TRUE;
		break;
	}


	MYFREEEX(pbBuf);
	if( hHid  != INVALID_HANDLE_VALUE ){ CloseHandle( hHid ); }

	return bResult;
}




BOOL
WriteUSB_IO(
	IN BYTE bCommand,
	IN BYTE bPort,
	OUT PMYHID_USB pmyhid_usb
	)
{
	SECURITY_ATTRIBUTES sa;
	BOOL bRet;
	PBYTE pbBuf;
	DWORD dwWritten;
	HANDLE hHid  = INVALID_HANDLE_VALUE;
	BOOL bResult = FALSE;

	// Check write data caps
	if( (pmyhid_usb==NULL) ||
		(pmyhid_usb->hidp_caps.OutputReportByteLength==0) ||
		(pmyhid_usb->hidp_caps.OutputReportByteLength<9)  ||
		(pmyhid_usb->hidp_caps.InputReportByteLength==0)  ||
		(pmyhid_usb->hidp_caps.InputReportByteLength<2)
		){
		DBGMSG( DBG_ERROR, ("Error : ReadUSB_IO() Invalid data PMYHID_USB!\n") );
		return FALSE;
	}

	for(;;){
		// Write command data
		pbBuf = MYALLOC(pmyhid_usb->hidp_caps.OutputReportByteLength+1);
		if( pbBuf == NULL ){
			DBGMSG( DBG_ERROR, ("Error : WriteUSB_IO() can't get memory [%d]\n", GetLastError()) );
			break;
		}

		sa.nLength = sizeof(SECURITY_ATTRIBUTES);
		sa.lpSecurityDescriptor = NULL;
		sa.bInheritHandle = FALSE;

		hHid = CreateFile(	pmyhid_usb->pszPath,
							GENERIC_READ|GENERIC_WRITE,
							FILE_SHARE_READ|FILE_SHARE_WRITE,
							&sa, OPEN_EXISTING, 0, NULL );

		if( hHid == INVALID_HANDLE_VALUE ){
			DBGMSG( DBG_ERROR, ("Error : CreateFile()[%d]\n", GetLastError()) );
			DBGMSG( DBG_ERROR, ("Error : port name [%s]\n", pmyhid_usb->pszPath) );
			break;
		}
		
		*(pbBuf+0) = 0;			// Report ID is no mentenance
		*(pbBuf+1) = bCommand;	// command id
		*(pbBuf+2) = bPort;		// command data
		*(pbBuf+3) = 0xF1;		// dummy
		*(pbBuf+4) = 0xF2;
		*(pbBuf+5) = 0xF3;
		*(pbBuf+6) = 0xF4;
		*(pbBuf+7) = 0xF5;

		bRet = WriteFile( hHid, pbBuf, pmyhid_usb->hidp_caps.OutputReportByteLength, &dwWritten, NULL );
		if( !bRet ){
			DBGMSG( DBG_ERROR, ("Error : WriteFile()[%d]\n", GetLastError()) );
			break;
		}

		// success
		bResult = TRUE;
		break;
	}

	MYFREEEX(pbBuf);
	if( hHid  != INVALID_HANDLE_VALUE ){ CloseHandle( hHid ); }

	return bResult;
}

