/*
 * USB-IO test program
 * 01.05.28 : Makoto NARA(Mc.N)
 */

/*
 * Copyright (c) 2001 Makoto NARA(Mc.N) All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY Makoto NARA(Mc.N) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */



#ifndef _USBIO_H
#define _USBIO_H

#include "mydbg.h"
#include "myhid.h"

#define USBIO_VENDORID		(0x0BFE)
#define USBIO_PRODUCTID_V2	(0x1003)
#define USBIO_PRODUCTID_V1	(0x1002)

#define USBIO_VERSION		1	// major version is 0, minor version is 1(0.01)

#define USBIO_WRITE_P0		1	// 01 xx : P0 write
#define USBIO_WRITE_P1		2	// 02 0x : P1 write
#define USBIO_READ_P0		3	// 03    : P0 read
#define USBIO_READ_P1		4	// 04    : P1 read

#define USBIO_WRITE_P0_P10	16	// 16 xx : pulse P1_0, write P0
#define USBIO_WRITE_P0_P11	17	// 17 xx : pulse P1_1, write P0
#define USBIO_WRITE_P0_P12	18	// 18 xx : pulse P1_2, write P0
#define USBIO_WRITE_P0_P13	19	// 19 xx : pulse P1_3, write P0
#define USBIO_READ_P0_P10	20	// 20    : pulse P1_0, read P0
#define USBIO_READ_P0_P11	21	// 21    : pulse P1_1, read P0
#define USBIO_READ_P0_P12	22	// 22    : pulse P1_2, read P0
#define USBIO_READ_P0_P13	23	// 23    : pulse P1_3, read P0




#endif // _USBIO_H
